// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package pdb;

/**
  base class for PDB residue (amino acids, water, lipids, ions, ...)
**/

class ResidueBase {
  /**
    residue index
  **/
  @:isVar public var index( get, set ):Int;
    /**
      getter for `index`
    **/
    public function get_index():Int { return( index ); }
    /**
      setter for `index`
    **/
    public function set_index( i:Int ):Int {
      index = i;
      return( index );
    }
  /**
    is an N-terminal residue?
  **/
  @:isVar public var isNterm( get, set ):Bool;
    /**
      getter for `isNterm`
    **/
    public function get_isNterm():Bool { return( isNterm ); }
    /**
      setter for `isNterm`
    **/
    public function set_isNterm( b:Bool ):Bool {
      isNterm = b;
      return( isNterm );
    }
  /**
    is a C-terminal residue?
  **/
  @:isVar public var isCterm( get, set ):Bool;
    /**
      getter for `isCterm`
    **/
    public function get_isCterm():Bool { return( isCterm ); }
    /**
      setter for `isCterm`
    **/
    public function set_isCterm( b:Bool ):Bool {
      isCterm = b;
      return( isCterm );
    }
  /**
    residue name
  **/
  @:isVar public var name( get, set ):String;
    /**
      getter for `name`
    **/
    public function get_name():String { return( name ); }
    /**
      setter for `name`
    **/
    public function set_name( s:String ):String {
      name = s;
      return( name );
    }

  //-------------------------------------------------------------------------

  /**
    Constructor.

    - n: residue name
    - i: residue index
    - isnt: is N-terminal?
    - isct: is C-terminal?
  **/
  public function new( ?n:String = "",
                       ?i:Int = -1,
                       ?isnt:Bool = false,
                       ?isct:Bool = false ) {
    name = n;
    index = i;
    isNterm = isnt;
    isCterm = isct;
  }
}
