class SimpleShaderUV extends format.hxsl.Shader {
  static public var id:String = "SimpleShaderUV";
  static var SRC = {
    var input : {
      pos:Float3,
      uv:Float2,
    };
    var tuv:Float2;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3 ) {
      out = pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      tuv = uv;
    }
    function fragment( tex:Texture ) {
      var t = tex.get( tuv );
      out = [ t.x, t.y, t.z, 1.0 ];
    }
  };
}
