class PhongShaderUVDC extends format.hxsl.Shader {
  static public var id:String = "PhongShaderUV";
  static var SRC = {
    include( 'srcWithUV.hxsl' );
    var position:Float3;
    var normal:Float3;
    var tuv:Float2;
    include( 'vertexPhongUV.hxsl' );
    function fragment( tex:Texture,
                       light:Float3,
                       cpos:Float3,
                       ambient:Float,
                       diffuse:Float,
                       specular:Float,
                       gloss:Float,
                       alpha:Float,
                       dc:Float,
                       dclength:Float ) {
      var tnorm = normalize( normal );
      var lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      // specular using half vector
      var view = normalize( sub( cpos, position ));
      var half = normalize( add( light, view ));
      var spow = specular * pow( max( 0, dot( half, tnorm ) ), gloss );
      var t = tex.get( tuv ) * lpow + spow;
      var dccoeff = saturate( exp( - dc * ( position.z - dclength ) ) );
      out = [ dccoeff * t.x, dccoeff * t.y, dccoeff * t.z, alpha ];
    }
  };
}
