class PhongShader extends format.hxsl.Shader {
  static public var id:String = "PhongShader";
  static var SRC = {
    include( 'srcNoUV.hxsl' );
    var position:Float3;
    var normal:Float3;
    include( 'vertexPhong.hxsl' );
    function fragment( light:Float3,
                       cpos:Float3,
                       ambient:Float,
                       diffuse:Float,
                       specular:Float,
                       gloss:Float,
                       col:Float3,
                       alpha:Float ) {
      var tnorm = normalize( normal );
      var lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      // specular using half vector
      var view = normalize( sub( cpos, position ) );
      var half = normalize( add( light, view ) );
      var spow = specular * pow( max( 0, dot( half, tnorm ) ), gloss );
      var x = spow + col.x * lpow;
      var y = spow + col.y * lpow;
      var z = spow + col.z * lpow;
      out = [ x, y, z, alpha ];
    }
  };
}
