class GouraudShaderUVDC extends format.hxsl.Shader {
  static public var id:String = "GouraudShaderUV";
  static var SRC = {
    include( 'srcWithUV.hxsl' );
    var tuv:Float2;
    var lpow:Float;
    var zpos:Float;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3,
                     light:Float3,
                     ambient:Float,
                     diffuse:Float ) {
      out = pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      var tnorm = normalize( norm * mpos );
      lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      tuv = uv;
      zpos = pos.z;
    }
    function fragment( tex:Texture,
                       alpha:Float,
                       dc:Float,
                       dclength:Float ) {
      var t = tex.get( tuv ) * lpow;
      var dccoeff = saturate( exp( - dc * ( zpos - dclength ) ) );
      out = [ dccoeff * t.x, dccoeff * t.y, dccoeff * t.z, alpha ];
    }
  }
}
