class GouraudShaderDC extends format.hxsl.Shader {
  static public var id:String = "GouraudShader";
  static var SRC = {
    include( 'srcNoUV.hxsl' );
    var color:Float3;
    var zpos:Float;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3,
                     light:Float3,
                     ambient:Float,
                     diffuse:Float,
                     col:Float3 ) {
      out = pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      var tnorm = normalize( norm * mpos );
      var lpow = diffuse * max( 0, dot( light, tnorm )) + ambient;
      color = col * lpow;
      zpos = pos.z;
    }
    function fragment( alpha:Float,
                       dc:Float,
                       dclength:Float ) {
      var dccoeff = saturate( exp( - dc * ( zpos - dclength ) ) );
      out = [ dccoeff * color.x, dccoeff * color.y, dccoeff * color.z, alpha ];
    }
  }
}
