// container for default values for each <SCENE>
class WMDefaults {
  // global default
  static public var gl_Atom:WMBase =
           new WMBase( 4.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.35, 0.7,
                       0.8, 20, "Phong" );
  static public var gl_Bond:WMBase =
           new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 2, 0.3, 1.0,
                       0.6, 20, "Phong" );
  static public var gl_BondRound:Bool = true;
  static public var gl_BondExclude:Bool = false;
  static public var gl_BondDashed:Int = 0;
  static public var gl_Coil:WMBase =
          new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.7,
                      0.8, 10, "Phong" );
  static public var gl_Ribbon:WMBase =
          new WMBase( 8.0, 0xFF0000, 0xFF0000, 1.0, 0.0, 0, 0.3, 0.7,
                      0.8, 10, "Phong" );
  static public var gl_RibbonThickness:Float = 0.0;
  static public var gl_RibbonSmoothing:Bool = false;
  static public var gl_Label:WMBase =
         new WMBase( 130.0, 0xFFFFFF, 0xFFFFFF, 1.0, 0.0, 0, 0.0, 0.0,
                     0.0, 20, "2DUV" );
  static public var gl_LabelFont:String = "Arial";
  static public var gl_LabelSize:Float = 32.0;
  static public var gl_Shape:WMBase =
         new WMBase( 0.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.5,
                     0.2, 20.0, "Phong" );
  static public var gl_Object3D:WMBase =
         new WMBase( 1.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.35, 0.7,
                     0.8, 20, "Phong" );
  static public var gl_Object3DType:String = "cone";

  // ########################################################################

  // <SCENE> local default
  public var Atom( __getAtomDef, __setAtomDef ):WMBase;
    public function __getAtomDef():WMBase { return( Atom ); }
    public function __setAtomDef( a:WMBase ):WMBase {
      if ( Atom == null ) Atom = new WMBase();
      Atom.copyFrom( a );
      return( Atom );
    }

  public var Bond( __getBondDef, __setBondDef ):WMBase;
    public function __getBondDef():WMBase { return( Bond ); }
    public function __setBondDef( b:WMBase ):WMBase {
      if ( Bond == null ) Bond = new WMBase();
      Bond.copyFrom( b );
      return( Bond );
    }
  public var BondRound( __getBondRoundDef, __setBondRoundDef ):Bool;
    public function __getBondRoundDef():Bool { return( BondRound ); }
    public function __setBondRoundDef( f:Bool ):Bool {
      BondRound = f;
      return( BondRound );
    }
  public var BondExclude( __getBondExcludeDef, __setBondExcludeDef ):Bool;
    public function __getBondExcludeDef():Bool { return( BondExclude ); }
    public function __setBondExcludeDef( f:Bool ):Bool {
      BondExclude = f;
      return( BondExclude );
    }
  public var BondDashed( __getBondDashedDef, __setBondDashedDef ):Int;
    public function __getBondDashedDef():Int { return( BondDashed ); }
    public function __setBondDashedDef( d:Int ):Int {
      BondDashed = d;
      return( BondDashed );
    }

  public var Coil( __getCoilDef, __setCoilDef ):WMBase;
    public function __getCoilDef():WMBase { return( Coil ); }
    public function __setCoilDef( c:WMBase ):WMBase {
      if ( Coil == null ) Coil = new WMBase();
      Coil.copyFrom( c );
      return( Coil );
    }

  public var Ribbon( __getRibbonDef, __setRibbonDef ):WMBase;
    public function __getRibbonDef():WMBase { return( Ribbon ); }
    public function __setRibbonDef( r:WMBase ):WMBase {
      if ( Ribbon == null ) Ribbon = new WMBase();
      Ribbon.copyFrom( r );
      return( Ribbon );
    }
  public var RibbonThickness( __getRibbonThicknessDef, __setRibbonThicknessDef ):Float;
    public function __getRibbonThicknessDef():Float { return( RibbonThickness ); }
    public function __setRibbonThicknessDef( t:Float ):Float {
      RibbonThickness = t;
      return( RibbonThickness );
    }
  public var RibbonSmoothing( __getRibbonSmoothingDef, __setRibbonSmoothingDef ):Bool;
    public function __getRibbonSmoothingDef():Bool { return( RibbonSmoothing ); }
    public function __setRibbonSmoothingDef( b:Bool ):Bool {
      RibbonSmoothing = b;
      return( RibbonSmoothing );
    }

  public var Label( __getLabelDef, __setLabelDef ):WMBase;
    public function __getLabelDef():WMBase { return( Label ); }
    public function __setLabelDef( l:WMBase ):WMBase {
      if ( Label == null ) Label = new WMBase();
      Label.copyFrom( l );
      return( Label );
    }
  public var LabelFont( __getLabelFontDef, __setLabelFontDef ):String;
    public function __getLabelFontDef():String { return( LabelFont ); }
    public function __setLabelFontDef( f:String ):String {
      LabelFont = f;
      return( LabelFont );
    }
  public var LabelSize( __getLabelSizeDef, __setLabelSizeDef ):Float;
    public function __getLabelSizeDef():Float { return( LabelSize ); }
    public function __setLabelSizeDef( s:Float ):Float {
      LabelSize = s;
      return( LabelSize );
    }

  public var Shape( __getShapeDef, __setShapeDef ):WMBase;
    public function __getShapeDef():WMBase { return( Shape ); }
    public function __setShapeDef( s:WMBase ):WMBase {
      if ( Shape == null ) Shape = new WMBase();
      Shape.copyFrom( s );
      return( Shape );
    }

  public var Object3D( __getObject3DDef, __setObject3DDef ):WMBase;
    public function __getObject3DDef():WMBase { return( Object3D ); }
    public function __setObject3DDef( o:WMBase ):WMBase {
      if ( Object3D == null ) Object3D = new WMBase();
      Object3D.copyFrom( o );
        return( Object3D );
    }
  public var Object3DType( __getObject3DTypeDef, __setObject3DTypeDef ):String;
    public function __getObject3DTypeDef():String { return( Object3DType ); }
    public function __setObject3DTypeDef( t:String ):String {
      Object3DType = t;
      return( Object3DType );
    }

  // ########################################################################

  public function new() {
    Atom = new WMBase();
    Atom.copyFrom( gl_Atom );
    Bond = new WMBase();
    Bond.copyFrom( gl_Bond );
    BondRound = gl_BondRound;
    BondExclude = gl_BondExclude;
    BondDashed = gl_BondDashed;
    Ribbon = new WMBase();
    Ribbon.copyFrom( gl_Ribbon );
    RibbonThickness = gl_RibbonThickness;
    RibbonSmoothing = gl_RibbonSmoothing;
    Coil = new WMBase();
    Coil.copyFrom( gl_Coil );
    Label = new WMBase();
    Label.copyFrom( gl_Label );
    LabelFont = gl_LabelFont;
    LabelSize = gl_LabelSize;
    Shape = new WMBase();
    Shape.copyFrom( gl_Shape );
    Object3D = new WMBase();
    Object3D.copyFrom( gl_Object3D );
    Object3DType = gl_Object3DType;
  }
}
