class Ribbon3D extends Polygon {
  public function new( p0:Array< Point3D >,
                       p1:Array< Point3D > ) {
    super();
    init( p0, p1 );
  }

  public function init( p0:Array< Point3D >,
                        p1:Array< Point3D > ) {
    if ( p0 == null && p1 == null ) return;
    if ( p0.length != p1.length ||
         p0 == null || p1 == null ) {
      trace( "Ribbon3D: invalid call" );
      return;
    }
    var num = p0.length;
    for ( p in p0 ) addVertexPos( p );
    for ( p in p1 ) addVertexPos( p );
    for ( p in p0 ) addVertexPos( p );
    for ( p in p1 ) addVertexPos( p );

    var duv:Float = 1.0 / ( num - 1 );
    var u0:Array< UVCoord > = new Array< UVCoord >();
    var u1:Array< UVCoord > = new Array< UVCoord >();
    for ( i in 0 ... num ) {
      u0.push( new UVCoord( duv * i, 0.0 ) );
      u1.push( new UVCoord( duv * i, 1.0 ) );
    }

    var num2 = num + num;
    for ( i in 0 ... num - 1 ) {
      var j = i + num;
      addFace( new Face( i, j+1, i+1, u0[i], u1[i+1], u0[i+1] ) );
      addFace( new Face( j, j+1, i, u1[i], u1[i+1], u0[i] ) );
      addFace( new Face( i+num2, i+1+num2, j+1+num2, u0[i], u0[i+1], u1[i+1] ) );
      addFace( new Face( j+num2, i+num2, j+1+num2, u1[i], u0[i], u1[i+1] ) );
    }
  }
}
