class PdbResidue {
  public var hetero( __isHetero, __setHetero ):Bool;
    public function __isHetero():Bool { return( hetero ); }
    public function __setHetero( h:Bool ):Bool { hetero = h; return( hetero ); }

  public var terminal( __isTerminal, __setTerminal ):Bool;
    public function __isTerminal():Bool { return( terminal ); }
    public function __setTerminal( t:Bool ):Bool { terminal = t; return( terminal ); }

  public var atoms( __getAtoms, null ):Array< PdbAtom >;
    public function __getAtoms():Array< PdbAtom > { return( atoms ); }

  public var index( __getIndex, __setIndex ):Int;
    public function __getIndex():Int { return( index ); }
    public function __setIndex( i:Int ):Int { index = i; return( index ); }

  public var name( __getName, __setName ):String;
    public function __getName():String { return( name ); }
    public function __setName( n:String ):String { name = n; return( name ); }

  public var secondary( __getSecondary, __setSecondary ):String;
    public function __getSecondary():String { return( secondary ); }
    public function __setSecondary( s:String ):String { secondary = s; return( secondary ); }

  // ########################################################################

  public function new( ?h:Bool = false,
                       ?n:String = "",
                       ?i:Int = 1,
                       ?sec:String = "coil" ) {
    hetero = h;
    atoms = new Array< PdbAtom >();
    index = i;
    name = n;
    secondary = sec;
    terminal = false;
  }

  public function addAtom( a:PdbAtom ):Void { atoms.push( a.clone() ); }

  // write position of alpha-carbon, "CA"
  public function genPoint():String {
    if ( hetero ) return( "" );
    for ( atom in atoms ) {
      if ( StringTools.trim( atom.name ) == "CA" ) {
        // atom.pos.toString() must not be used;
        // that function flips z-coordinate
        return( "      <POINT index=\"" + index +
                "\" pos=\"" + atom.pos.x +
                        " " + atom.pos.y +
                        " " + atom.pos.z + "\" />\n" );
      }
    }
    return( "" );
  }
}
