import flash.display.Sprite;
import flash.display.Stage;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.events.Event;
import flash.events.MouseEvent;

class WMPdb extends Sprite {
  private var __wm( null, null ):Watermelon;

  // colors
  public var bgColor( __getBackgroundColor, __setBackgroundColor ):Int;
    public function __getBackgroundColor():Int { return( bgColor ); }
    public function __setBackgroundColor( c:Int ):Int {
      bgColor = c;
      return( bgColor );
    }

  // alpha
  public var bgAlpha( __getBackgroundAlpha, __setBackgroundAlpha ):Float;
    public function __getBackgroundAlpha():Float { return( bgAlpha ); }
    public function __setBackgroundAlpha( a:Float ):Float {
      bgAlpha = a;
      return( bgAlpha );
    }

  // font
  public var fontname( __getFontName, __setFontName ):String;
    public function __getFontName():String { return( fontname ); }
    public function __setFontName( f:String ):String {
      fontname = f;
      return( fontname );
    }

  public var fontcolor( __getFontColor, __setFontColor ):Int;
    public function __getFontColor():Int { return( fontcolor ); }
    public function __setFontColor( c:Int ):Int {
      fontcolor = c;
      return( fontcolor );
    }

  public var fontsize( __getFontSize, __setFontSize ):Float;
    public function __getFontSize():Float { return( fontsize ); }
    public function __setFontSize( s:Float ):Float {
      fontsize = s;
      return( fontsize );
    }

  public var posRatioW( __getPosRatioW, __setPosRatioW ):Float;
    public function __getPosRatioW():Float { return( posRatioW ); }
    public function __setPosRatioW( r:Float ):Float {
      posRatioW = r;
      return( posRatioW );
    }

  public var posRatioH( __getPosRatioH, __setPosRatioH ):Float;
    public function __getPosRatioH():Float { return( posRatioH ); }
    public function __setPosRatioH( r:Float ):Float {
      posRatioH = r;
      return( posRatioH );
    }

  public var margin( __getMargin, __setMargin ):Float;
    public function __getMargin():Float { return( margin ); }
    public function __setMargin( m:Float ):Float {
      margin = m;
      return( margin );
    }

  // ########################################################################
  public function new( ?wm:Watermelon = null ) {
    super();
    __wm = wm;
    bgColor = 0x00FF00;
    bgAlpha = 0.5;
    fontname = "Arial";
    fontcolor = 0xFF0000;
    fontsize = 12;

    posRatioW = 0.2;
    posRatioH = 0.3;

    __fillBackground();
    __generateMessageField();
    __generateInputField();
    __generateOKButton();
    __generateCancelButton();
  }

  private function __generateMessageField():Void {
    var ret:TextField = new TextField();
    var tf:TextFormat = new TextFormat( fontname, fontsize, fontcolor );
    ret.setTextFormat( tf );
    ret.defaultTextFormat = tf;
    ret.text = "Please input PDB id.";
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.CENTER;
    ret.x = ( posRatioW + 0.02 ) * __wm.stage.stageWidth;
    ret.y = ( posRatioH + 0.05 ) * __wm.stage.stageHeight;
    this.addChild( ret );
  }

  private function __generateInputField():Void {
    var ret:TextField = new TextField();
    var tf:TextFormat = new TextFormat( fontname, fontsize, 0x000000 );
    ret.setTextFormat( tf );
    ret.defaultTextFormat = tf;
    ret.text = "";
    ret.name = "PDB_ID";
    ret.type = flash.text.TextFieldType.INPUT;
    ret.width = 0.6 * this.width;
    ret.height = 0.2 * this.height;
    ret.background = true;
    ret.border = true;
    ret.x = 1.5 * posRatioW * __wm.stage.stageWidth;
    ret.y = 1.5 * posRatioH * __wm.stage.stageHeight;
    this.addChild( ret );
  }

  private function __generateOKButton():Void {
    var ok:TextField = new TextField();
    ok.border = true;
    ok.background = true;
    ok.text = "OK";
    ok.setTextFormat( new TextFormat( fontname, fontsize, 0x000000 ) );
    ok.selectable = false;
    ok.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var okbutton:Sprite = new Sprite();
    okbutton.addChild( ok );
    okbutton.x = 1.3 * posRatioW * __wm.stage.stageWidth;
    okbutton.y = 2.0 * posRatioH * __wm.stage.stageHeight;
    var ref = this;
    okbutton.addEventListener( MouseEvent.CLICK,
                               function( e:Event ) {
                                 var d:Dynamic = ref.getChildByName( "PDB_ID" );
                                 var s:String = d.text;
                                 ref.__wm.stage.removeChild( ref );
                                 ref.__wm.retrievePdbFromRCSB( s );
                                 ref.__wm.states.busyNow = false;
                               }
                             );
    this.addChild( okbutton );
  }

  private function __generateCancelButton():Void {
    var cancel:TextField = new TextField();
    cancel.border = true;
    cancel.background = true;
    cancel.text = "Cancel";
    cancel.setTextFormat( new TextFormat( fontname, fontsize, 0x000000 ) );
    cancel.selectable = false;
    cancel.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var cancelbutton:Sprite = new Sprite();
    cancelbutton.addChild( cancel );
    cancelbutton.x = 2.0 * posRatioW * __wm.stage.stageWidth;
    cancelbutton.y = 2.0 * posRatioH * __wm.stage.stageHeight;
    var ref = this;
    cancelbutton.addEventListener( MouseEvent.CLICK,
                                   function( e:Event ) {
                                     ref.__wm.stage.removeChild( ref );
                                     ref.__wm.states.busyNow = false;
                                   }
                                 );
    this.addChild( cancelbutton );
  }

  private function __fillBackground():Void {
    this.graphics.beginFill( bgColor, bgAlpha );
    this.graphics.drawRect( posRatioW * __wm.stage.stageWidth,
                            posRatioH * __wm.stage.stageHeight,
                            ( 1.0 - 2 * posRatioW ) * __wm.stage.stageWidth,
                            ( 1.0 - 2 * posRatioH ) * __wm.stage.stageHeight );
    this.graphics.endFill();
  }
}
