// Container for the parameters used in wm3d.
// Almost all variables are referenced by parent class, Watermelon
// Thus, most variables should be defined as public one.

// variables in this class may not be modified by standard usage unlike
// those in WMStates.

class WMParams {
  private var wm:Watermelon;

  // trace color
  public var traceColor( __getTraceColor, __setTraceColor ):Int;
    public function __getTraceColor():Int { return( traceColor ); }
    public function __setTraceColor( c:Int ) {
      traceColor = c;
      return( traceColor );
    }

  // auto-rotation parameter
  public var arDegree( __getARDegree, __setARDegree ):Float;
    public function __getARDegree():Float { return( arDegree ); }
    public function __setARDegree( d:Float ):Float {
      arDegree = Math.max( d, 0.0 );
      if ( arDegree == 0.0 && wm.states != null ) {
        wm.states.stopAutoRotation();
      }
      return( arDegree );
    }

  // scaling parameters
  //// scaling parameter when scaled by mouse wheel
  public var scaleWheel( __getScaleWheel, __setScaleWheel ):Float;
    public function __getScaleWheel():Float { return( scaleWheel ); }
    public function __setScaleWheel( s:Float ) {
      scaleWheel = Math.max( s, 0.0 );
      return( scaleWheel );
    }

  //// scaling parameter for the automatic scaling during loading mol
  public var scaleFactorAuto( __getScaleFactorAuto, __setScaleFactorAuto ):Float;
    public function __getScaleFactorAuto():Float { return( scaleFactorAuto ); }
    public function __setScaleFactorAuto( f:Float ) {
      scaleFactorAuto = Math.max( f, 0.0 );
      return( scaleFactorAuto );
    }

  //// manually defined scaling factor during loading mol
  public var scaleFactorManual( __getScaleFactorManual, __setScaleFactorManual ):Float;
    public function __getScaleFactorManual():Float { return( scaleFactorManual ); }
    public function __setScaleFactorManual( f:Float ):Float {
      scaleFactorManual = Math.max( f, 0.0 );
      return( scaleFactorManual );
    }

  // depth change parameter
  public var depthWheel( __getDepthWheel, __setDepthWheel ):Float;
    public function __getDepthWheel():Float { return( depthWheel ); }
    public function __setDepthWheel( f:Float ) {
      depthWheel = Math.max( f, 0.0 );
      return( depthWheel );
    }

  // framerate for playing (meaningful only if there are multiple scenes)
  public var playFrameRate( __getPlayFrameRate, __setPlayFrameRate ):Float;
    public function __getPlayFrameRate():Float { return( playFrameRate ); }
    public function __setPlayFrameRate( r:Float ):Float {
      playFrameRate = Math.max( r, 0.0 );
      return( playFrameRate );
    }

  // number of frames displayed for a scene
  // this value is determined by the framerate of the flash and framerate of
  // playFrameRate.
  public var numFramesPerScene( __getNumFramesPerScene, __setNumFramesPerScene ):Int;
    public function __getNumFramesPerScene():Int { return( numFramesPerScene ); }
    public function __setNumFramesPerScene( n:Int ) {
      numFramesPerScene = n;
      return( numFramesPerScene );
    }

  // scale factor used in rotation with mouse move
  public var mouseMoveRotatScale( __getMouseMoveRotatScale, __setMouseMoveRotatScale ):Float;
    public function __getMouseMoveRotatScale():Float { return( mouseMoveRotatScale ); }
    public function __setMouseMoveRotatScale( s:Float ) {
      mouseMoveRotatScale = s;
      return( mouseMoveRotatScale );
    }

  // scale factor used in scaling with mouse move
  public var mouseMoveScaleScale( __getMouseMoveScaleScale, __setMouseMoveScaleScale ):Float;
    public function __getMouseMoveScaleScale():Float { return( mouseMoveScaleScale ); }
    public function __setMouseMoveScaleScale( s:Float ):Float {
      mouseMoveScaleScale = s;
      return( mouseMoveScaleScale );
    }

  // parameter-like flags
  // these params may not be modified while viewing structure.
  //// whether prevent edit/save
  public var protectData( __getProtectData, __setProtectData ):Bool;
    public function __getProtectData():Bool { return( protectData ); }
    public function __setProtectData( f:Bool ) {
      protectData = f;
      return( protectData );
    }

  //// whether read molecules in the background
  public var readBackground(  __getReadBackground, __setReadBackground ):Bool;
    public function __getReadBackground():Bool { return( readBackground ); }
    public function __setReadBackground( f:Bool ) {
      readBackground = f;
      return( readBackground );
    }

  //// whether inherit scaling parameter from the first SCENE
  public var inheritScale( __getInheritScale, __setInheritScale ):Bool;
    public function __getInheritScale():Bool { return( inheritScale ); }
    public function __setInheritScale( f:Bool ) {
      inheritScale = f;
      return( inheritScale );
    }

  //// whether activate auto scaling when loading
  public var doAutoScale( __getDoAutoScale, __setDoAutoScale ):Bool;
    public function __getDoAutoScale():Bool { return( doAutoScale ); }
    public function __setDoAutoScale( f:Bool ):Bool {
      doAutoScale = f;
      return( doAutoScale );
    }

  public function new( w:Watermelon ) {
    wm = w;
    // default values
    traceColor = 0xFF0000;

    arDegree = 1.5;
    scaleWheel = 0.01;
    depthWheel = 0.04 * Math.max( wm.stage.stageWidth, wm.stage.stageHeight );
    playFrameRate = 3.0; // 3 frames per sec (at most)

    mouseMoveRotatScale = 30.0;
    mouseMoveScaleScale = 15.0;

    protectData = false;
    readBackground = false;
    numFramesPerScene = -1;

    inheritScale = true;
    doAutoScale = true;
    scaleFactorAuto = 0.3;
    scaleFactorManual = 10.0;
  }

  public function assignNumFramesPerScene():Void {
    numFramesPerScene = Std.int( wm.stage.frameRate / playFrameRate );
  }
}
