class GouraudShaderUV extends format.hxsl.Shader {
  static public var id:String = "GouraudShaderUV";
  static var SRC = {
    var input : {
      pos:Float3,
      norm:Float3,
      uv:Float2,
    }
    var tuv:Float2;
    var lpow:Float;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3,
                     light:Float3,
                     ambient:Float,
                     diffuse:Float ) {
      out = pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      var tnorm = normalize( norm * mpos );
      lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      tuv = uv;
    }
    function fragment( tex:Texture,
                       alpha:Float ) {
      var t = tex.get( tuv ) * lpow;
      out = [ t.x, t.y, t.z, alpha ];
    }
  }
}
