// available secondary structure names are
// "helix", "strand", "coil", and "none".

class PdbSecondary {
  static public function readHelixFromText( text:String ):PdbSecondary {
    var i:Int = Std.parseInt( text.substr( 21, 4 ) );
    var l:Int = Std.parseInt( text.substr( 33, 4 ) );
    var c:String = text.substr( 19, 1 );
    return( new PdbSecondary( i, l, c, "helix" ) );
  }

  static public function readStrandFromText( text:String ):PdbSecondary {
    var i:Int = Std.parseInt( text.substr( 22, 4 ) );
    var l:Int = Std.parseInt( text.substr( 33, 4 ) );
    var c:String = text.substr( 21, 1 );
    return( new PdbSecondary( i, l, c, "strand" ) );
  }

  // #####################################################################

  public var init( __getInit, __setInit ):Int;
    public function __getInit():Int { return( init ); }
    public function __setInit( i:Int ):Int { init = i; return( init ); }
  public var last( __getLast, __setLast ):Int;
    public function __getLast():Int { return( last ); }
    public function __setLast( l:Int ):Int { last = l; return( last ); }
  public var sectype( __getType, __setType ):String;
    public function __getType():String { return( sectype ); }
    public function __setType( t:String ):String {
      if ( t != null ) {
        if ( t == "helix" || t == "strand" || t == "coil" || t == "none" ) {
          sectype = t;
        }
      } else {
        sectype = "";
      }
      return( sectype );
    }
  public var chainid( __getChainId, __setChainId ):String;
    public function __getChainId():String { return( chainid ); }
    public function __setChainId( i:String ):String { chainid = i; return( chainid ); }

  // ########################################################################

  public function new( ?i:Int,
                       ?l:Int,
                       ?c:String,
                       ?st:String ) {
    if ( i != null ) init = i;
    if ( l != null ) last = l;
    if ( c != null ) chainid = c;
    if ( st != null ) sectype = st;
  }
}
