import flash.display.Sprite;
import flash.display.Stage;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.events.Event;
import flash.events.MouseEvent;

class WMEdit extends Sprite {
  private var wm( null, null ):Watermelon;

  // background
  public var bgColor( __getBackgroundColor, __setBackgroundColor ):Int;
    public function __getBackgroundColor():Int { return( bgColor ); }
    public function __setBackgroundColor( c:Int ):Int {
      bgColor = c;
      return( bgColor );
    }

  public var bgAlpha( __getBackgroundAlpha, __setBackgroundAlpha ):Float;
    public function __getBackgroundAlpha():Float { return( bgAlpha ); }
    public function __setBackgroundAlpha( a:Float ):Float {
      bgAlpha = a;
      return( bgAlpha );
    }

  // font
  public var fontname( __getFontName, __setFontName ):String;
    public function __getFontName():String { return( fontname ); }
    public function __setFontName( f:String ):String {
      fontname = f;
      return( fontname );
    }

  public var fontsizemain( __getFontSizeMain, __setFontSizeMain ):Float;
    public function __getFontSizeMain():Float { return( fontsizemain ); }
    public function __setFontSizeMain( s:Float ):Float {
      fontsizemain = s;
      return( fontsizemain );
    }

  public var fontsizebutton( __getFontSizeButton, __setFontSizeButton ):Float;
    public function __getFontSizeButton():Float { return( fontsizebutton ); }
    public function __setFontSizeButton( s:Float ):Float {
      fontsizebutton = s;
      return( fontsizebutton );
    }

  public var fontcolormain( __getFontColorMain, __setFontColorMain ):Int;
    public function __getFontColorMain():Int { return( fontcolormain ); }
    public function __setFontColorMain( c:Int ):Int {
      fontcolormain = c;
      return( fontcolormain );
    }

  public var fontcolorbutton( __getFontColorButton, __setFontColorButton ):Int;
    public function __getFontColorButton():Int { return( fontcolorbutton ); }
    public function __setFontColorButton( c:Int ):Int {
      fontcolorbutton = c;
      return( fontcolorbutton );
    }

  // textfield window size
  public var ratio_windowsize_x( __getRatioWindowSizeX, __setRatioWindowSizeX ):Float;
    public function __getRatioWindowSizeX():Float { return( ratio_windowsize_x ); }
    public function __setRatioWindowSizeX( r:Float ):Float {
      ratio_windowsize_x = r;
      return( ratio_windowsize_x );
    }

  public var ratio_windowsize_y( __getRatioWindowSizeY, __setRatioWindowSizeY ):Float;
    public function __getRatioWindowSizeY():Float { return( ratio_windowsize_y ); }
    public function __setRatioWindowSizeY( r:Float ):Float {
      ratio_windowsize_y = r;
      return( ratio_windowsize_y );
    }

  public var ratio_windowpos_x( __getRatioWindowPosX, __setRatioWindowPosX ):Float;
    public function __getRatioWindowPosX():Float { return( ratio_windowpos_x ); }
    public function __setRatioWindowPosX( r:Float ):Float {
      ratio_windowpos_x = r;
      return( ratio_windowpos_x );
    }

  public var ratio_windowpos_y( __getRatioWindowPosY, __setRatioWindowPosY ):Float;
    public function __getRatioWindowPosY():Float { return( ratio_windowpos_y ); }
    public function __setRatioWindowPosY( r:Float ):Float {
      ratio_windowpos_y = r;
      return( ratio_windowpos_y );
    }

  // button positions
  public var ratio_ok_pos_x( __getRatioPosOKButtonX, __setRatioPosOKButtonX ):Float;
    public function __getRatioPosOKButtonX():Float { return( ratio_ok_pos_x ); }
    public function __setRatioPosOKButtonX( r:Float ):Float {
      ratio_ok_pos_x = r;
      return( ratio_ok_pos_x );
    }

  public var ratio_ok_pos_y( __getRatioPosOKButtonY, __setRatioPosOKButtonY ):Float;
    public function __getRatioPosOKButtonY():Float { return( ratio_ok_pos_y ); }
    public function __setRatioPosOKButtonY( r:Float ):Float {
      ratio_ok_pos_y = r;
      return( ratio_ok_pos_y );
    }

  public var ratio_cancel_pos_x( __getRatioPosCancelButtonX, __setRatioPosCancelButtonX ):Float;
    public function __getRatioPosCancelButtonX():Float { return( ratio_cancel_pos_x ); }
    public function __setRatioPosCancelButtonX( r:Float ):Float {
      ratio_cancel_pos_x = r;
      return( ratio_cancel_pos_x );
    }

  public var ratio_cancel_pos_y( __getRatioPosCancelButtonY, __setRatioPosCancelButtonY ):Float;
    public function __getRatioPosCancelButtonY():Float { return( ratio_cancel_pos_y ); }
    public function __setRatioPosCancelButtonY( r:Float ):Float {
      ratio_cancel_pos_y = r;
      return( ratio_cancel_pos_y );
    }

  // ####################################################################

  public function new( melon:Watermelon ) {
    super();
    wm = melon;

    // default values
    bgColor = 0x00FF00;
    bgAlpha = 0.5;
    fontname = "Arial";
    fontsizemain = 12;
    fontsizebutton = 16;
    fontcolormain = 0x000000;
    fontcolorbutton = 0x000000;
    ratio_windowsize_x = 0.7;
    ratio_windowsize_y = 0.7;
    ratio_windowpos_x = 0.1;
    ratio_windowpos_y = 0.1;
    ratio_ok_pos_x = 0.6;
    ratio_ok_pos_y = 0.85;
    ratio_cancel_pos_x = 0.7;
    ratio_cancel_pos_y = 0.85;
  }

  // draw
  public function draw() {
    this.graphics.clear();
    this.removeChildren();

    fillBackground();
    createTextField();
    createOKButton();
    createCancelButton();

    return( this );
  }

  private function fillBackground():Void {
    this.graphics.beginFill( bgColor, bgAlpha );
    this.graphics.drawRect( 0, 0, wm.stage.stageWidth, wm.stage.stageHeight );
    this.graphics.endFill();
  }

  private function createTextField():Void {
    var tf:TextFieldWithScrollBar =
        new TextFieldWithScrollBar( this,
            new TextFormat( fontname, fontsizemain, fontcolormain ),
            ratio_windowsize_x * wm.stage.stageWidth,
            ratio_windowsize_y * wm.stage.stageHeight,
            12, wm.myString );
    tf.name = "EDIT_WINDOW";
    tf.x = ratio_windowpos_x * wm.stage.stageWidth;
    tf.y = ratio_windowpos_y * wm.stage.stageHeight;
    this.addChild( tf );
  }

  private function createOKButton():Void {
    var ok:TextField = new TextField();
    ok.border = true;
    ok.background = true;
    ok.text = "OK";
    ok.setTextFormat( new TextFormat( fontname, fontsizebutton ) );
    ok.selectable = false;
    ok.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var okbutton:Sprite = new Sprite();
    okbutton.addChild( ok );
    this.addChild( okbutton );
    okbutton.x = ratio_ok_pos_x * wm.stage.stageWidth;
    okbutton.y = ratio_ok_pos_y * wm.stage.stageHeight;
    var ref = this;
    okbutton.addEventListener( MouseEvent.CLICK,
                               function( e:Event ) {
                                 var d:Dynamic = ref.getChildByName( "EDIT_WINDOW" );
                                 var s:String = d.getText();
                                 ref.wm.states.busyNow = false;
                                 ref.wm.stage.removeChild( ref );
                                 ref.wm.visualize( s );
                               } );
  }

  private function createCancelButton():Void {
    var cancel:TextField = new TextField();
    cancel.border = true;
    cancel.background = true;
    cancel.text = "Cancel";
    cancel.setTextFormat( new TextFormat( fontname, fontsizebutton ) );
    cancel.selectable = false;
    cancel.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var cancelbutton:Sprite = new Sprite();
    cancelbutton.addChild( cancel );
    this.addChild( cancelbutton );
    cancelbutton.x = ratio_cancel_pos_x * wm.stage.stageWidth;
    cancelbutton.y = ratio_cancel_pos_y * wm.stage.stageHeight;
    var ref = this;
    cancelbutton.addEventListener( MouseEvent.CLICK,
                                   function( e:Event ) {
                                     ref.wm.states.busyNow = false;
                                     ref.wm.stage.removeChild( ref );
                                   } );
  }
}
