import flash.display.Sprite;
import flash.display.Stage;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.events.Event;
import flash.events.MouseEvent;

class WMAbout extends Sprite {
  static public var version:String = "0.32";
  private var mystage( null, null ):Stage;

  // colors
  public var bgColor( __getBackgroundColor, __setBackgroundColor ):Int;
    public function __getBackgroundColor():Int { return( bgColor ); }
    public function __setBackgroundColor( c:Int ):Int {
      bgColor = c;
      return( bgColor );
    }

  // alpha
  public var bgAlpha( __getBackgroundAlpha, __setBackgroundAlpha ):Float;
    public function __getBackgroundAlpha():Float { return( bgAlpha ); }
    public function __setBackgroundAlpha( a:Float ):Float {
      bgAlpha = a;
      return( bgAlpha );
    }

  // font
  public var fontname( __getFontName, __setFontName ):String;
    public function __getFontName():String { return( fontname ); }
    public function __setFontName( f:String ):String {
      fontname = f;
      return( fontname );
    }

  // font colors
  public var softnameColor( __getSoftwareNameColor, __setSoftwareNameColor ):Int;
    public function __getSoftwareNameColor():Int { return( softnameColor ); }
    public function __setSoftwareNameColor( c:Int ):Int {
      softnameColor = c;
      return( softnameColor );
    }

  public var versionColor( __getVersionColor, __setVersionColor ):Int;
    public function __getVersionColor():Int { return( versionColor ); }
    public function __setVersionColor( c:Int ):Int {
      versionColor = c;
      return( versionColor );
    }

  public var descriptionColor( __getDescriptionColor, __setDescriptionColor ):Int;
    public function __getDescriptionColor():Int { return( descriptionColor ); }
    public function __setDescriptionColor( c:Int ):Int {
      descriptionColor = c;
      return( descriptionColor );
    }

  public var noticeColor( __getNoticeColor, __setNoticeColor ):Int;
    public function __getNoticeColor():Int { return( noticeColor ); }
    public function __setNoticeColor( c:Int ):Int {
      noticeColor = c;
      return( noticeColor );
    }

  // font ratios
  public var font_large_ratio( __getFontLargeRatio, __setFontLargeRatio ):Float;
    public function __getFontLargeRatio():Float { return( font_large_ratio ); }
    public function __setFontLargeRatio( f:Float ):Float {
      font_large_ratio = f;
      return( font_large_ratio );
    }

  public var font_small_ratio( __getFontSmallRatio, __setFontSmallRatio ):Float;
    public function __getFontSmallRatio():Float { return( font_small_ratio ); }
    public function __setFontSmallRatio( f:Float ):Float {
      font_small_ratio = f;
      return( font_small_ratio );
    }

  // margin ratio
  public var margin_ratio( __getMarginRatio, __setMarginRatio ):Float;
    public function __getMarginRatio():Float { return( margin_ratio ); }
    public function __setMarginRatio( f:Float ):Float {
      margin_ratio = f;
      return( margin_ratio );
    }

  // font sizes
  public var font_size_large( __getFontSizeLarge, __setFontSizeLarge ):Float;
    public function __getFontSizeLarge():Float { return( font_size_large ); }
    public function __setFontSizeLarge( f:Float ):Float {
      font_size_large = f;
      return( font_size_large );
    }

  public var font_size_small( __getFontSizeSmall, __setFontSizeSmall ):Float;
    public function __getFontSizeSmall():Float { return( font_size_small ); }
    public function __setFontSizeSmall( f:Float ):Float {
      font_size_small = f;
      return( font_size_small );
    }

  // window size margin
  public var margin( __getMargin, __setMargin ):Int;
    public function __getMargin():Int { return( margin ); }
    public function __setMargin( f:Int ):Int {
      margin = f;
      return( margin );
    }

  // #####################################################################

  public function new( ?win:Stage = null ) {
    super();
    if ( win == null ) {
      win = flash.Lib.current.stage;
    }
    // mystage shall not be null
    mystage = win;
    this.name = "about";
    // default values
    setFontSizeLargeByRatio( 0.05 );
    setFontSizeSmallByRatio( 0.03 );
    setMarginByRatio( 0.1 );
    bgColor = 0x00FF00; // green
    bgAlpha = 0.5;
    fontname = "Arial";
    softnameColor = 0x000000; // wm3d
    versionColor = 0x000000; // version: (ver)
    descriptionColor = 0xFF0000;
    noticeColor = 0x000000; // click this window to ...
  }

  // draws
  //// draw main
  public function drawAbout() {
    // reset drawing
    this.graphics.clear();
    this.removeChildren();
    // reset font sizes and margin size
    resetFontSizes();
    setMarginByRatio();
    // do it
    fillBackground();
    this.addChild( __tfSoftwareName() );
    this.addChild( __tfVersion() );
    this.addChild( __tfDescription() );
    this.addChild( __tfNotice() );
    // event listener
    var refstage = this.mystage;
    if ( !this.hasEventListener( MouseEvent.CLICK ) ) {
      // commit suicide when clicked
      this.addEventListener( MouseEvent.CLICK,
                             function( e:Event ) {
                               refstage.removeChild( refstage.getChildByName( "about" ) );
                             } );
    }
    return( this );
  }

  //// software name
  private function __tfSoftwareName():TextField {
    var ret:TextField = new TextField();
    ret.y = margin * 2;
    ret.width = mystage.stageWidth;
    ret.text = "wm3d";
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.CENTER;
    ret.setTextFormat( new TextFormat( fontname, font_size_large, softnameColor, true, null, null, null, flash.text.TextFormatAlign.CENTER ) );
    return( ret );
  }

  //// version name
  private function __tfVersion():TextField {
    var ret:TextField = new TextField();
    ret.y = margin * 2.5;
    ret.width = mystage.stageWidth;
    ret.text = "version: " + WMAbout.version;
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.RIGHT;
    ret.setTextFormat( new TextFormat( fontname, font_size_small, versionColor, true, null, null, null, flash.text.TextFormatAlign.RIGHT ) );
    return( ret );
  }

  //// description about this software
  private function __tfDescription():TextField {
    var ret:TextField = new TextField();
    ret.y = margin * 4;
    ret.width = mystage.stageWidth;
    ret.text = "simple flash molecular viewer\n" +
               "written with Haxe\n" +
               "©2011-2012 tamanegi. All rights reserved.\n\n" +
               "wm3d is licensed under MPL1.1/GPL2.0+/LGPL2.1+ trilicense.";
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.CENTER;
    ret.setTextFormat( new TextFormat( fontname, font_size_small, descriptionColor, true, null, null, null, flash.text.TextFormatAlign.CENTER ) );
    return( ret );
  }

  //// notice message for users
  private function __tfNotice():TextField {
    var ret:TextField = new TextField();
    ret.y = mystage.stageHeight - 2 * margin;
    ret.width = mystage.stageWidth;
    ret.text = "click this window to remove message.";
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.RIGHT;
    ret.setTextFormat( new TextFormat( fontname, font_size_small, noticeColor, true, null, null, null, flash.text.TextFormatAlign.RIGHT ) );
    return( ret );
  }

  //// fill background
  private function fillBackground():Void {
    this.graphics.beginFill( bgColor, bgAlpha );
    this.graphics.drawRect( 0, margin, mystage.stageWidth, mystage.stageHeight - 2 * margin );
    this.graphics.endFill();
  }

  // utilities
  public function resetFontSizes():Void {
    setFontSizeLargeByRatio();
    setFontSizeSmallByRatio();
  }

  public function setFontSizeLargeByRatio( ?f:Float ):Void {
    if ( f != null ) {
      font_large_ratio = f;
    }
    font_size_large = mystage.stageWidth * font_large_ratio;
  }

  public function setFontSizeSmallByRatio( ?f:Float ):Void {
    if ( f != null ) {
      font_small_ratio = f;
    }
    font_size_small = mystage.stageWidth * font_small_ratio;
  }

  public function setMarginByRatio( ?f:Float ):Void {
    if ( f != null ) {
      margin_ratio = f;
    }
    margin = Std.int( mystage.stageHeight * margin_ratio );
  }
}
