import flash.events.TimerEvent;
import flash.utils.Timer;

import flash.text.TextField;
import flash.text.TextFormat;

class Main {
  static public var minimum_major:Int = 11;
  static public var minimum_minor:Int = 2;

  static public var _this:Main;
  private var _timer:Timer;
  public var wm:Watermelon;

  static function main() {
    _this = new Main();
  }

  static function checkVersion():Bool {
    var platform_version:Array< String > = flash.system.Capabilities.version.split( " " );
    if ( platform_version.length >= 2 ) {
      var version:Array< String > = platform_version[1].split(",");
      if ( version.length >= 2 ) {
        var major:Int = Std.parseInt( version[0] );
        var minor:Int = Std.parseInt( version[1] );
        if ( major <= minimum_major && minor < minimum_minor ) {
          Main.pleaseUpdatePlayer( major, minor );
          return( false );
        }
      }
    }
    return( true );
  }

  static function pleaseUpdatePlayer( major:Int,
                                      minor:Int ) {
    var ret:TextField = new TextField();
    ret.width = flash.Lib.current.stage.stageWidth;
    ret.text = "Please update flash player to\n version " +
               Std.string( minimum_major ) + "." + Std.string( minimum_minor ) +
               " or later.\n\n" +
               "Version of this player is " +
               Std.string( major ) + "." + Std.string( minor ) + ".";
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.CENTER;
    ret.setTextFormat( new TextFormat( "Arial", 12, 0x000000, true, null, null, null, flash.text.TextFormatAlign.CENTER ) );
    ret.y = flash.Lib.current.stage.stageHeight / 2.0;
    flash.Lib.current.stage.addChild( ret );
  }

  private function new() {
    _timer = new Timer( 40 );
    _timer.addEventListener( TimerEvent.TIMER, isReady );
    _timer.start();
  }

  private function isReady( ?e:TimerEvent = null ):Void {
    if ( flash.Lib.current.stage != null ) {
      if ( Std.is( flash.Lib.current.stage.stageWidth, Int ) &&
           Std.is( flash.Lib.current.stage.stageHeight, Int ) ) {
        _timer.stop();
        if ( Main.checkVersion() ) {
          wm = new Watermelon();
        }
      }
    }
  }
}
