// base class for objects in Watermelon

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

import flash.display3D.Context3D;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

class WMObjBase extends WMBase {
  public var _polygon( get, null ):Dynamic;

  public function new( ?r:Float = 0.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 0.5,
                       ?sp:Float = 0.2,
                       ?gl:Float = 20.0,
                       ?sh:String = "Phong" ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
  }

  public override function clear( ?def:WMDefaults = null ):Void {
    if ( def != null ) {
      copyFrom( def.Atom );
    } else {
      radius = 0.0;
      color0 = 0x000000;
      color1 = 0x000000;
      alpha = 1.0;
      offset = 0.0;
      quality = 0;
      ambient = 0.3;
      diffuse = 0.5;
      specular = 0.2;
      gloss = 20.0;
      shader = "Phong";
    }
    _polygon = null;
  }

  public function draw( c:Context3D,
                        mpos:Matrix3D,
                        proj:Matrix3D,
                        voffset:Vector3D,
                        ?light:Vector3D = null,
                        ?cpos:Vector3D = null ):Bool {
    return( _polygon.draw( c, mpos, proj, voffset, light, cpos ) );
  }

  public function dump():String {
    var d:Dynamic = Type.getClass( this );
    var type:String = d.id;

    var str:String = " c=" + "\"" + color0 + "\"" +
                     " c0=" + "\"" + color0 + "\"" +
                     " c1=" + "\"" + color1 + "\"" +
                     " a=" + "\"" + alpha + "\"" +
                     " o=" + "\"" + offset + "\"" +
                     " am=" + "\"" + ambient + "\"" +
                     " s=" + "\"" + specular + "\"" +
                     " g=" + "\"" + gloss + "\"" +
                     " type=" + "\"" + type + "\"" +
                     " shader="+ "\"" + shader + "\"";
    return( _polygon.dump( str ) );
  }

  public function get():Dynamic { return( _polygon ); }
}
