class WMAlias {
  public var name( __getName, __setName ):String;
  public var elem( __getElement, __setElement ):String;
  public var mybase( __getMyBase, null ):Dynamic;

  public function new() {
    name = "";
    elem = "";
    mybase = null;
  }

  public function register( t:String,
                            x:Xml ):Void {
    name = t;
    elem = x.get( "elem" ).toUpperCase();
    switch( elem ) {
      case "ATOM":
        mybase = new WMAtom();
        mybase.copyFrom( WMDefaults.gl_Atom );
      case "BOND":
        mybase = new WMBond();
        mybase.copyFrom( WMDefaults.gl_Bond );
        mybase.rounded = WMDefaults.gl_BondRound;
        mybase.exclude = WMDefaults.gl_BondExclude;
        mybase.dashed = WMDefaults.gl_BondDashed;
      case "COIL":
        mybase = new WMRibbon( false );
        mybase.copyFrom( WMDefaults.gl_Coil );
      case "RIBBON":
        mybase = new WMRibbon( true );
        mybase.copyFrom( WMDefaults.gl_Ribbon );
        mybase.thickness = WMDefaults.gl_RibbonThickness;
      case "LABEL":
        mybase = new WMLabel();
        mybase.copyFrom( WMDefaults.gl_Label );
        mybase.font = WMDefaults.gl_LabelFont;
        mybase.fontsize = WMDefaults.gl_LabelSize;
      case "SHAPE":
        mybase = new WMShape();
        mybase.copyFrom( WMDefaults.gl_Shape );
      case "OBJ3D":
        mybase = new WMObject3D();
        mybase.copyFrom( WMDefaults.gl_Object3D );
        mybase.type = WMDefaults.gl_Object3DType;
    }
    mybase.loadFromXmlOverwrite( x );
  }

  // getter
  public function __getElement():String { return( elem ); }
  public function __getName():String { return( name ); }
  public function __getMyBase():Dynamic { return( mybase ); }

  // setter
  public function __setElement( e:String ):String {
    elem = e;
    return( elem );
  }
  public function __setName( n:String ):String {
    name = n;
    return( name );
  }
}
