/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      AnimEditorCommandManager.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.Text;
using GSCommon;

namespace War02.animEditor
{
    /**
     * Aj[VGfB^ŎgpR}hID`NX
     */
    class CommandID
    {
        public const Int32 SHOW_NEW_ANIMATION_DLG = 1;
    }


    /**
     * Aj[VGfB^sR}h̊ǗsNX
     */
    class AnimEditorCommandManager
    {
        ///vWFNg
        private Project _project;

        ///R}ḧꗗ
        private Dictionary<Int32, ICommand> _commandList;

        
        /**
         * RXgN^
         * @param project GfB^ҏWvWFNg
         */
        public AnimEditorCommandManager(Project project)
        {
            _project = project;
            _commandList = new Dictionary<Int32, ICommand>();
        }


        /**
         * NX̏s
         */
        private void _initialize()
        {
            _commandList.Add(CommandID.SHOW_NEW_ANIMATION_DLG, ShowNewAnimationDlgCommand);
        }
    }


    /**
     * Aj[V̐VKǉ_CAO\
     */
    class ShowNewAnimationDlgCommand : ICommand
    {
        /**
         * RXgN^
         */
        public ShowNewAnimationDlgCommand()
        {
            Id = CommandID.SHOW_NEW_ANIMATION_DLG;
            Text = "Aj[V̐VK쐬";
            Desc = "Aj[VVK쐬܂B";
        }

        /**
         * R}hs
         */
        public override void execute()
        {
            
        }
    }
}
