/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      GroupTree.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using GSCommon;

namespace GSCommon.UI
{
    /**
     * O[vKw̉ɃACec[r[
     */
    class GroupTreeView : TreeView, IGroupItemListener
    {
        ///O[ṽ^CvID
        public const Int32 TYPE_GROUP = 1;
        ///ACẽ^CvID
        public const Int32 TYPE_ITEM  = 2;

        ///r[ɕ\ACeǗĂRNVNX
        IGroupItemCollection _collection;

        /**
         * RXgN^
         */
        public GroupTreeView()
        {
            _collection = null;
        }


        /**
         * RNVNXw肵ARNV̕ωĎ
         * @param itemCollection ACëꗗێĂNX
         */
        public void setItemCollection(IGroupItemCollection itemCollection)
        {
            _collection = itemCollection;
            _collection.addGroupItemLisener(this);
        }


        /**
         * r[ɃO[vǉ
         * @param group ǉO[v
         */
        public void addGroup(Group group)
        {
            String key = makeKey(TYPE_GROUP, group.ID);

            if(Nodes.ContainsKey(key))
            {
                return;
            }

            TreeNode node = new TreeNode(group.Name);
            node.Name = key;
            node.Tag = group;

            Nodes.Add(node);
        }


        /**
         * r[ɃACeǉ
         * @param item ǉACe
         */
        public void addItem(IGroupItem item)
        {
            String key = makeKey(TYPE_GROUP, item.GroupID);
            if(!Nodes.ContainsKey(key))
            {
                return;
            }

            TreeNode node = new TreeNode(item.Name);
            node.Name = makeKey(TYPE_ITEM, item.ID);
            node.Tag = item;

            TreeNode[] groupNodes = Nodes.Find(key, false);
            if(groupNodes.Length == 0)
            {
                return;
            }
            groupNodes[0].Nodes.Add(node);
        }


        /**
         * r[̊em[hɊ蓖ĂL[vZĕԂB
         * @param typeId ^CvID
         * @param itemId ACeID
         * @return m[hɊ蓖ĂL[
         */
        public String makeKey(Int32 typeId, Int32 itemId)
        {
            //ł́u^CvID_(ACe|O[v)IDvB
            return String.Format("{0}_{1}", typeId, itemId);
        }


        /**
         * ĎĂRNVɕύXɌĂяo
         * @param e p[^
         */
        public void updateList(GroupItemChangeEvent e)
        {
            return;
        }
    }
}
