#pragma once

/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 * @link      http://war02.sourceforge.jp/
 */

using namespace System;

namespace war02 {
namespace core {

    /**
     * Aj[Ṽ[ṼNX
     * @package war02.core
     */
    ref class Motion
    {
        public: static const int ID_NORMAL = 1; ///ʏ̃[VID
        public: static const int ID_DASH   = 2; ///_bṼ[VID
        public: static const int ID_PUNCH  = 3; ///p`̃[VID
        public: static const int ID_KICK   = 4; ///LbÑ[VID
        public: static const int ID_JUMP   = 5; ///Wṽ[VID

        private: Int32 id;  ///[VID
        private: String^ name;  ///[V

        /**
         * RXgN^
         * 
         * @param Int32   new_id [VID
         * @param String^ new_name [V̖O
         */
        public: 
        Motion(Int32 new_id, String^ new_name)
        {
            id = new_id;
            name = new_name;
        }


        /**
         * [VIDԂB
         * @return [VID
         */
        public:
        Int32 getID()
        { return id; }


        /**
         * [V̖OԂ
         * @return [V
         */
        public:
        String^ getName()
        { return name; }


        /**
         * NX̕\Ԃ
         * ObjectNXToString̃I[o[Ch
         * (GfB^[ނł̃NXR{{bNX
         * ACeƂĎgp邽)
         * @return [V
         */
        public:
        virtual String^ ToString() override
        { return getName(); }
    };

} //namespace core end
} //namespace war02 end
