#pragma once

/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 * @link      http://war02.sourceforge.jp/
 */


using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
using namespace Collections::Generic;

#include "Project.h"
#include "Config.h"

using namespace war02::core;

namespace war02 {
namespace animEditor {


    /**
     * AvP[ṼCEBhE
     */
    public ref class MainFrame : public System::Windows::Forms::Form
	{
	public:
		MainFrame(void)
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//
		}

	protected:

        ~MainFrame()
		{
			if (components)
			{
				delete components;
			}
		}
    private: System::Windows::Forms::MenuStrip^  menuStrip;
    private: System::Windows::Forms::ToolStripMenuItem^  MenuItem_File;

    protected: 

    private: System::Windows::Forms::ToolStripMenuItem^  menuItem_NewProject;
    private: System::Windows::Forms::ToolStripSeparator^  toolStripSeparator1;
    private: System::Windows::Forms::ToolStripMenuItem^  menuItemEnd;

    private: System::Windows::Forms::ToolStripMenuItem^  menuItem_OpenProject;
    private: System::Windows::Forms::Panel^  panel1;
    private: System::Windows::Forms::TabControl^  tabFrame;
    private: System::Windows::Forms::TabPage^  tabCharacter;
    private: System::Windows::Forms::TabPage^  tabMisc;
    private: System::Windows::Forms::ComboBox^  comboMotion;



    private: System::Windows::Forms::TreeView^  animationTree;

	private:
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code

		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
            this->menuStrip = (gcnew System::Windows::Forms::MenuStrip());
            this->MenuItem_File = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->menuItem_NewProject = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->menuItem_OpenProject = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->toolStripSeparator1 = (gcnew System::Windows::Forms::ToolStripSeparator());
            this->menuItemEnd = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->panel1 = (gcnew System::Windows::Forms::Panel());
            this->tabFrame = (gcnew System::Windows::Forms::TabControl());
            this->tabCharacter = (gcnew System::Windows::Forms::TabPage());
            this->animationTree = (gcnew System::Windows::Forms::TreeView());
            this->comboMotion = (gcnew System::Windows::Forms::ComboBox());
            this->tabMisc = (gcnew System::Windows::Forms::TabPage());
            this->menuStrip->SuspendLayout();
            this->panel1->SuspendLayout();
            this->tabFrame->SuspendLayout();
            this->tabCharacter->SuspendLayout();
            this->SuspendLayout();

            // 
            // menuStrip
            // 
            this->menuStrip->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->MenuItem_File});
            this->menuStrip->Location = System::Drawing::Point(0, 0);
            this->menuStrip->Name = L"menuStrip";
            this->menuStrip->Size = System::Drawing::Size(619, 24);
            this->menuStrip->TabIndex = 1;
            this->menuStrip->Text = L"menuStrip1";
            // 
            // MenuItem_File
            // 
            this->MenuItem_File->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(4) {this->menuItem_NewProject, 
                this->menuItem_OpenProject, this->toolStripSeparator1, this->menuItemEnd});
            this->MenuItem_File->Name = L"MenuItem_File";
            this->MenuItem_File->Size = System::Drawing::Size(51, 20);
            this->MenuItem_File->Text = L"t@C";
            // 
            // menuItem_NewProject
            // 
            this->menuItem_NewProject->Name = L"menuItem_NewProject";
            this->menuItem_NewProject->Size = System::Drawing::Size(145, 22);
            this->menuItem_NewProject->Text = L"VKvWFNg";
            this->menuItem_NewProject->Click += gcnew System::EventHandler(this, &MainFrame::menuItem_NewProject_Click);
            // 
            // menuItem_OpenProject
            // 
            this->menuItem_OpenProject->Name = L"menuItem_OpenProject";
            this->menuItem_OpenProject->Size = System::Drawing::Size(145, 22);
            this->menuItem_OpenProject->Text = L"J...";
            // 
            // toolStripSeparator1
            // 
            this->toolStripSeparator1->Name = L"toolStripSeparator1";
            this->toolStripSeparator1->Size = System::Drawing::Size(142, 6);
            // 
            // menuItemEnd
            // 
            this->menuItemEnd->Name = L"menuItemEnd";
            this->menuItemEnd->Size = System::Drawing::Size(145, 22);
            this->menuItemEnd->Text = L"I";
            // 
            // panel1
            // 
            this->panel1->Controls->Add(this->tabFrame);
            this->panel1->Dock = System::Windows::Forms::DockStyle::Left;
            this->panel1->Location = System::Drawing::Point(0, 24);
            this->panel1->Name = L"panel1";
            this->panel1->Size = System::Drawing::Size(176, 405);
            this->panel1->TabIndex = 4;
            // 
            // tabFrame
            // 
            this->tabFrame->Controls->Add(this->tabCharacter);
            this->tabFrame->Controls->Add(this->tabMisc);
            this->tabFrame->Dock = System::Windows::Forms::DockStyle::Fill;
            this->tabFrame->Location = System::Drawing::Point(0, 0);
            this->tabFrame->Name = L"tabFrame";
            this->tabFrame->SelectedIndex = 0;
            this->tabFrame->Size = System::Drawing::Size(176, 405);
            this->tabFrame->TabIndex = 0;
            // 
            // tabCharacter
            // 
            this->tabCharacter->Controls->Add(this->animationTree);
            this->tabCharacter->Controls->Add(this->comboMotion);
            this->tabCharacter->Location = System::Drawing::Point(4, 21);
            this->tabCharacter->Name = L"tabCharacter";
            this->tabCharacter->Padding = System::Windows::Forms::Padding(3);
            this->tabCharacter->Size = System::Drawing::Size(168, 380);
            this->tabCharacter->TabIndex = 0;
            this->tabCharacter->Text = L"LN^[";
            this->tabCharacter->UseVisualStyleBackColor = true;
            // 
            // animationTree
            // 
            this->animationTree->Location = System::Drawing::Point(8, 32);
            this->animationTree->Name = L"animationTree";
            this->animationTree->Size = System::Drawing::Size(153, 304);
            this->animationTree->TabIndex = 4;
            // 
            // comboMotion
            // 
            this->comboMotion->FormattingEnabled = true;
            this->comboMotion->Location = System::Drawing::Point(8, 6);
            this->comboMotion->Name = L"comboMotion";
            this->comboMotion->Size = System::Drawing::Size(153, 20);
            this->comboMotion->TabIndex = 0;
            // 
            // tabMisc
            // 
            this->tabMisc->Location = System::Drawing::Point(4, 21);
            this->tabMisc->Name = L"tabMisc";
            this->tabMisc->Padding = System::Windows::Forms::Padding(3);
            this->tabMisc->Size = System::Drawing::Size(168, 380);
            this->tabMisc->TabIndex = 1;
            this->tabMisc->Text = L"̑";
            this->tabMisc->UseVisualStyleBackColor = true;
            // 
            // MainFrame
            // 
            this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->ClientSize = System::Drawing::Size(619, 429);
            this->Controls->Add(this->panel1);
            this->Controls->Add(this->menuStrip);
            this->IsMdiContainer = true;
            this->Name = L"MainFrame";
            this->Text = L"Aj[VGfB^[";
            this->Load += gcnew System::EventHandler(this, &MainFrame::MainFrame_Load);
            this->menuStrip->ResumeLayout(false);
            this->menuStrip->PerformLayout();
            this->panel1->ResumeLayout(false);
            this->tabFrame->ResumeLayout(false);
            this->tabCharacter->ResumeLayout(false);
            this->ResumeLayout(false);
            this->PerformLayout();
        }
#pragma endregion

    /**
     * CEBhE[hꂽɎs鏈
     * @param sender Cxg̔̃IuWFNg
     * @param e      Cxgp[^
     */
    private:
    System::Void MainFrame_Load(System::Object^  sender, System::EventArgs^  e)
    {
        Config^ config = Config::getInstance();

        //[VXg̏
        comboMotion->Items->AddRange(config->getMotionArray());

        //Aj[Vc[̏
        initAnimationTree();
    }

    /**
     * t@C->VKvWFNg@NbN̏B
     * vWFNg̏s
     * @param sender Cxg̔̃IuWFNg
     * @param e      Cxgp[^
     */
    private:
    System::Void menuItem_NewProject_Click(System::Object^  sender, System::EventArgs^  e)
    {
        Project^ project = Project::getInstance();
        project->init();
    }


    /**
     * Aj[Vc[
     */
    private:
    Void initAnimationTree()
    {
        Config^ config = Config::getInstance();
        
        //LN^[̃Aj[Vc[̏
        array<AnimationGroup^>^ groupArray = 
        {
            config->getAnimationGroupById(AnimationGroup::ID_FACE),
            config->getAnimationGroupById(AnimationGroup::ID_BODY),
            config->getAnimationGroupById(AnimationGroup::ID_WEAPON)
        };
        
        for(Int32 i=0; i<groupArray->Length; i++) {
            animationTree->Nodes->Add(groupArray[i]->getID().ToString(), groupArray[i]->getName());
        }
    }
};

} //namespace animEditor end
} //namespace war02 end
