#pragma once

/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 * @link      http://war02.sourceforge.jp/
 */

#include "Motion.h"
#include "AnimationGroup.h"

using namespace System;
using namespace Collections::Generic;

namespace war02 {
namespace core {

/**
 * Q[̐ݒi[NX
 * @package war02.core
 */
ref class Config
{
    private: static Config^ instance=nullptr;  ///NX̗B̃CX^X
    private: Dictionary<Int32, Motion^>^ motionList;  ///[VIDAOێ郊Xg
    private: Dictionary<Int32, AnimationGroup^>^ animationGroupList;  ///Aj[VO[vIDAOێ郊Xg

    /**
     * RXgN^
     * @private
     */
    private: 
    Config(void)
    {
        //[ṼXg
        motionList = gcnew Dictionary<Int32, Motion^>();
        motionList->Add(Motion::ID_NORMAL, gcnew Motion(Motion::ID_NORMAL, L"ʏ"));
        motionList->Add(Motion::ID_DASH, gcnew Motion(Motion::ID_DASH, L"_bV"));
        motionList->Add(Motion::ID_PUNCH, gcnew Motion(Motion::ID_PUNCH, L"p`"));
        motionList->Add(Motion::ID_KICK, gcnew Motion(Motion::ID_KICK, L"LbN"));
        motionList->Add(Motion::ID_JUMP, gcnew Motion(Motion::ID_JUMP, L"Wv"));

        //Aj[VO[ṽXg
        animationGroupList = gcnew Dictionary<Int32, AnimationGroup^>();
        animationGroupList->Add(AnimationGroup::ID_FACE, gcnew AnimationGroup(AnimationGroup::ID_FACE, L""));
        animationGroupList->Add(AnimationGroup::ID_BODY, gcnew AnimationGroup(AnimationGroup::ID_BODY, L""));
        animationGroupList->Add(AnimationGroup::ID_WEAPON, gcnew AnimationGroup(AnimationGroup::ID_WEAPON, L""));
        animationGroupList->Add(AnimationGroup::ID_EFFECT, gcnew AnimationGroup(AnimationGroup::ID_EFFECT, L"GtFNg"));
        animationGroupList->Add(AnimationGroup::ID_ITEM, gcnew AnimationGroup(AnimationGroup::ID_ITEM, L"ACe"));
        animationGroupList->Add(AnimationGroup::ID_MISC, gcnew AnimationGroup(AnimationGroup::ID_MISC, L"̑"));
    }


    /**
     * NX̗B̃CX^XԂ
     * @return ConfigNX̃CX^X
     */
    public:
    static Config^ getInstance()
    {
        if(instance == nullptr) {
            instance = gcnew Config();
        }
        return instance;
    }


    /**
     * [Ṽe[uzɊi[ĕԂ
     * @return [Ṽe[u
     */
    public:
    array<Motion^>^ getMotionArray()
    {
        array<Motion^>^ arr = gcnew array<Motion^>(motionList->Count);
        Int32 i=0;
        for each(KeyValuePair<Int32, Motion^> kvp in motionList) {
            arr->SetValue(kvp.Value, i++);
        }
        return arr;
    }


    /**
     * Aj[VO[ṽe[uzɊi[ĕԂ
     * @return Aj[VO[ṽe[u
     */
    public:
    array<AnimationGroup^>^ getAnimationGroups()
    {
        array<AnimationGroup^>^ arr = gcnew array<AnimationGroup^>(animationGroupList->Count);
        Int32 i=0;
        for each(KeyValuePair<Int32, AnimationGroup^> kvp in animationGroupList) {
            arr->SetValue(kvp.Value, i++);
        }
        return arr;
    }

    /**
     * w肳ꂽID̃Aj[VO[vԂ
     * @param Aj[VO[vID
     * @return Aj[VO[v
     */
    public:
    AnimationGroup^ getAnimationGroupById(Int32 id)
    {
        AnimationGroup^ animationGroup = nullptr;
        if(!animationGroupList->TryGetValue(id, animationGroup)) {
            //ŏIIɂ͗OɂH
            return nullptr;
        }
        return animationGroup;
    }
};


}  //namespace core end
}  //namespace war02 end
