#pragma once

/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      AnimationGroupList.h
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 * @link      http://war02.sourceforge.jp/
 */

using namespace System;
using namespace Collections::Generic;

#include "AnimationGroup.h"

namespace war02 {
namespace core {


namespace AnimationGroupID {
    /// ̃Aj[VO[vID
    const int FACE   = 1;
    /// ̂̃Aj[VO[vID
    const int BODY   = 2;
    ///̃Aj[VO[vID
    const int WEAPON = 3;
    ///GtFNg̃Aj[VO[vID
    const int EFFECT = 4;
    ///ACẽAj[VO[vID
    const int ITEM   = 5;
    ///̑̂̃̕Aj[VO[vID
    const int MISC   = 6;
}

/**
 * Aj[VO[ṽXgێNX
 * namespace war02.core
 */
ref class AnimationGroupList
{
private:

    /**
     * NX̗B̃CX^X
     * @private
     * @static
     */
    static AnimationGroupList^ instance = nullptr;

    /**
     * Aj[VO[vID̃Aj[VO[ṽe[u
     * @private
     */
    Dictionary<Int32, AnimationGroup^>^ groupList;



    /**
     * RXgN^
     * @private
     */
    private:
    AnimationGroupList(void)
    {
        groupList = gcnew Dictionary<Int32, AnimationGroup^>();
        groupList->Add(AnimationGroupID::FACE, gcnew AnimationGroup(AnimationGroupID::FACE, L""));
        groupList->Add(AnimationGroupID::BODY, gcnew AnimationGroup(AnimationGroupID::BODY, L""));
        groupList->Add(AnimationGroupID::WEAPON, gcnew AnimationGroup(AnimationGroupID::WEAPON, L""));
        groupList->Add(AnimationGroupID::EFFECT, gcnew AnimationGroup(AnimationGroupID::EFFECT, L"GtFNg"));
        groupList->Add(AnimationGroupID::ITEM, gcnew AnimationGroup(AnimationGroupID::ITEM, L"ACe"));
        groupList->Add(AnimationGroupID::MISC, gcnew AnimationGroup(AnimationGroupID::MISC, L"̑"));
    }


    /**
     * NX̃CX^XԂBsingletonłB
     * @static
     * @return NX̃CX^X
     */
    public:
    static AnimationGroupCollection^ getInstance()
    {
        if(instance == nullptr)
        {
            instance = gcnew AnimationGroupCollection();
        }
        return instance;
    }


    /**
     * w肳ꂽID̃Aj[VO[vԂ
     * @param id Aj[VO[vID
     * @return Aj[VO[v
     */
    public:
    AnimationGroup^ getGroup(Int32 id)
    {
        AnimationGroup^ group = nullptr;
        if(!groupList->TryGetValue(id, group))
        {
            //ۂɂ͗O
            return nullptr;
        }
        return group;
    }


    /**
     * Aj[VO[ṽe[uԂ
     * @return Aj[VO[ṽe[u
     */
    public:
    Dictionary<Int32, AnimationGroup^>^ getList()
    {
        return groupList;
    }


    /**
     * [Ṽe[uzɊi[ĕԂ
     * @return [Ṽe[u
     */
    public:
    array<AnimationGroup^>^ getListByArray()
    {
        array<AnimationGroup^>^ arr = gcnew array<AnimationGroup^>(List->Count);
        Int32 i=0;
        for each(KeyValuePair<Int32, AnimationGroup^> kvp in groupList) {
            arr->SetValue(kvp.Value, i++);
        }
        return arr;
    }
};


} //namespace core end
} //namespace war02 end
