/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;

public class CalcTools {
    public static void fillCalcSheetWithContent(XComponent xComponent, int n, int n2, int n3, int n4, int n5) throws Exception {
        try {
            XSpreadsheet xSpreadsheet = CalcTools.getSpreadSheetFromSheetDoc(xComponent, n);
            CalcTools.fillCalcSheetWithContent(xSpreadsheet, n2, n3, n4, n5);
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new com.sun.star.uno.Exception("Couldn't fill CalcSheet with content: " + exception.toString());
        }
    }

    public static void fillCalcSheetWithContent(XSpreadsheet xSpreadsheet, int n, int n2, int n3, int n4) throws Exception {
        try {
            Object[][] objectArray = new Object[n4][n3];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    objectArray[i][j] = new Double(10 * i + j);
                }
            }
            XCellRange xCellRange = null;
            try {
                xCellRange = xSpreadsheet.getCellRangeByPosition(n, n2, n + n3 - 1, n2 + n4 - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new com.sun.star.uno.Exception("Couldn't get CellRange from sheett: " + indexOutOfBoundsException.toString());
            }
            XCellRangeData xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)xCellRange);
            xCellRangeData.setDataArray(objectArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new com.sun.star.uno.Exception("Couldn't fill CalcSheet with content: " + exception.toString());
        }
    }

    public static XSpreadsheet getSpreadSheetFromSheetDoc(XComponent xComponent, int n) throws Exception {
        XSpreadsheet xSpreadsheet = null;
        try {
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
            XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            try {
                xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(n));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new com.sun.star.uno.Exception("Couldn't get sheet '" + n + "' : " + illegalArgumentException.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new com.sun.star.uno.Exception("Couldn't get sheet '" + n + "' : " + indexOutOfBoundsException.toString());
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new com.sun.star.uno.Exception("Couldn't get sheet '" + n + "' : " + wrappedTargetException.toString());
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new com.sun.star.uno.Exception("Couldn't get sheet '" + n + "' : " + exception.toString());
        }
        return xSpreadsheet;
    }
}

