/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLStylesImporter
extends TestCase {
    XComponent xImpressDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating an impress document");
            this.xImpressDoc = sOfficeFactory.createImpressDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing document ");
        this.xImpressDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        Object object;
        XStyleFamiliesSupplier xStyleFamiliesSupplier;
        XInterface xInterface = null;
        Object object2 = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object2 = xMultiServiceFactory.createInstance("com.sun.star.comp.Impress.XMLStylesImporter");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object2;
        printWriter.println("creating a new environment for Paragraph object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xImpressDoc);
        String[][] stringArrayArray = new String[][]{{"start", "office:document-styles", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:style", "CDATA", "http://openoffice.org/2000/style", "xmlns:fo", "CDATA", "http://www.w3.org/1999/XSL/Format", "xmlns:table", "CDATA", "http://openoffice.org/2000/table"}, {"start", "office:styles"}, {"start", "style:style", "style:name", "CDATA", "XMLImporter_test", "style:family", "CDATA", "graphics", "style:parent-style-name", "CDATA", "standard"}, {"end", "style:style"}, {"end", "office:styles"}, {"end", "office:document-styles"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        XInterface xInterface2 = null;
        try {
            xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xImpressDoc);
            object = xStyleFamiliesSupplier.getStyleFamilies();
            Object object3 = object.getByName("graphics");
            xInterface2 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, object3);
            printWriter.println("Styles before:");
            String[] stringArray = xInterface2.getElementNames();
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println("  " + stringArray[i]);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
        }
        xStyleFamiliesSupplier = xInterface2;
        object = printWriter;
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker((PrintWriter)object, (XNameAccess)((Object)xStyleFamiliesSupplier)){
            private final /* synthetic */ PrintWriter val$logF;
            private final /* synthetic */ XNameAccess val$stylesF;
            {
                this.val$logF = printWriter;
                this.val$stylesF = xNameAccess;
            }

            public boolean checkImport() {
                this.val$logF.println("Styles after:");
                String[] stringArray = this.val$stylesF.getElementNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.val$logF.println("  " + stringArray[i]);
                }
                return this.val$stylesF.hasByName("XMLImporter_test");
            }
        });
        return testEnvironment;
    }
}

