/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.tree.XMutableTreeDataModel;
import com.sun.star.awt.tree.XMutableTreeNode;
import com.sun.star.awt.tree.XTreeControl;
import com.sun.star.awt.tree.XTreeNode;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.SelectionType;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.UITools;
import util.utils;

public class UnoTreeControl
extends TestCase {
    private static XTextDocument xTextDoc;
    private static XMutableTreeDataModel mXTreeDataModel;
    private static XMultiServiceFactory mxMSF;
    private static PrintWriter log;
    private static boolean debug;
    static /* synthetic */ Class class$com$sun$star$awt$tree$XMutableTreeNode;
    static /* synthetic */ Class class$com$sun$star$awt$tree$XTreeNode;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        log = printWriter;
        debug = testParameters.getBool("DebugIsActive");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        String string = "UnoTreeControl-Test";
        mxMSF = (XMultiServiceFactory)testParameters.getMSF();
        XTreeControl xTreeControl = null;
        XMutableTreeNode xMutableTreeNode = null;
        try {
            mXTreeDataModel = (XMutableTreeDataModel)UnoRuntime.queryInterface(XMutableTreeDataModel.class, mxMSF.createInstance("com.sun.star.awt.tree.MutableTreeDataModel"));
            xMutableTreeNode = mXTreeDataModel.createNode("UnoTreeControl", false);
            xMutableTreeNode.setDataValue("UnoTreeControl");
            xMutableTreeNode.setExpandedGraphicURL("private:graphicrepository/sd/res/triangle_down.png");
            xMutableTreeNode.setCollapsedGraphicURL("private:graphicrepository/sd/res/triangle_right.png");
            this.fillNode(xMutableTreeNode);
            mXTreeDataModel.setRoot(xMutableTreeNode);
            object = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, mxMSF.createInstance("com.sun.star.awt.UnoControlDialogModel"));
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object);
            xPropertySet.setPropertyValue("PositionX", new Integer(50));
            xPropertySet.setPropertyValue("PositionY", new Integer(50));
            xPropertySet.setPropertyValue("Width", new Integer(256));
            xPropertySet.setPropertyValue("Height", new Integer(256));
            xPropertySet.setPropertyValue("Title", "Tree Control Test");
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, object);
            XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, xMultiServiceFactory.createInstance("com.sun.star.awt.tree.TreeControlModel"));
            XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlModel);
            xPropertySet2.setPropertyValue("SelectionType", SelectionType.NONE);
            xPropertySet2.setPropertyValue("PositionX", new Integer(3));
            xPropertySet2.setPropertyValue("PositionY", new Integer(3));
            xPropertySet2.setPropertyValue("Width", new Integer(253));
            xPropertySet2.setPropertyValue("Height", new Integer(253));
            xPropertySet2.setPropertyValue("DataModel", mXTreeDataModel);
            xPropertySet2.setPropertyValue("ShowsRootHandles", new Boolean(false));
            xPropertySet2.setPropertyValue("ShowsHandles", new Boolean(false));
            xPropertySet2.setPropertyValue("RootDisplayed", new Boolean(true));
            xPropertySet2.setPropertyValue("Editable", new Boolean(true));
            XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, object);
            xNameContainer.insertByName(string, xControlModel);
            XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, mxMSF.createInstance("com.sun.star.awt.UnoControlDialog"));
            xControl.setModel((XControlModel)object);
            XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, mxMSF.createInstance("com.sun.star.awt.Toolkit"));
            xControl.createPeer(xToolkit, null);
            XControlContainer xControlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)xControl);
            XTreeControl xTreeControl2 = (XTreeControl)UnoRuntime.queryInterface(XTreeControl.class, (Object)xControlContainer.getControl(string));
            xTreeControl2.expandNode(xMutableTreeNode);
            xTreeControl = xTreeControl2;
            XDialog xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xControl);
            execurteDialog execurteDialog2 = new execurteDialog(xDialog);
            execurteDialog2.start();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        object = new TestEnvironment(xTreeControl);
        ((TestEnvironment)object).addObjRelation("XTreeControl_Node", xMutableTreeNode);
        try {
            System.out.println("count of children: " + xMutableTreeNode.getChildCount());
            ((TestEnvironment)object).addObjRelation("Selections", new Object[]{xMutableTreeNode.getChildAt(0), xMutableTreeNode});
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("ERROR: could not add object relation 'Selections' because 'xNode.getChildAt(1) failed: " + indexOutOfBoundsException.toString());
        }
        ((TestEnvironment)object).addObjRelation("Comparer", new Comparator(){

            public int compare(Object object, Object object2) {
                XMutableTreeNode xMutableTreeNode = (XMutableTreeNode)UnoRuntime.queryInterface(class$com$sun$star$awt$tree$XMutableTreeNode == null ? (class$com$sun$star$awt$tree$XMutableTreeNode = UnoTreeControl.class$("com.sun.star.awt.tree.XMutableTreeNode")) : class$com$sun$star$awt$tree$XMutableTreeNode, object);
                XTreeNode xTreeNode = null;
                try {
                    xTreeNode = (XTreeNode)AnyConverter.toObject((Type)new Type(class$com$sun$star$awt$tree$XTreeNode == null ? (class$com$sun$star$awt$tree$XTreeNode = UnoTreeControl.class$("com.sun.star.awt.tree.XTreeNode")) : class$com$sun$star$awt$tree$XTreeNode), (Object)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                XMutableTreeNode xMutableTreeNode2 = (XMutableTreeNode)UnoRuntime.queryInterface(class$com$sun$star$awt$tree$XMutableTreeNode == null ? (class$com$sun$star$awt$tree$XMutableTreeNode = UnoTreeControl.class$("com.sun.star.awt.tree.XMutableTreeNode")) : class$com$sun$star$awt$tree$XMutableTreeNode, xTreeNode);
                if (((String)xMutableTreeNode.getDataValue()).equals((String)xMutableTreeNode2.getDataValue())) {
                    return 0;
                }
                return -1;
            }
        });
        System.out.println("ImplementationName: " + utils.getImplName(xTreeControl));
        return object;
    }

    private void fillNode(XMutableTreeNode xMutableTreeNode) {
        if (xMutableTreeNode.getChildCount() == 0) {
            String string = (String)xMutableTreeNode.getDataValue();
            String string2 = utils.getOfficeUserPath(mxMSF);
            Object object = null;
            try {
                object = mxMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace();
            }
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
            this.dirlist(string2, xMutableTreeNode);
        }
    }

    private void dirlist(String string, XMutableTreeNode xMutableTreeNode) {
        Object object = null;
        try {
            object = mxMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, object);
        XMutableTreeNode xMutableTreeNode2 = null;
        try {
            xMutableTreeNode2 = mXTreeDataModel.createNode(string.substring(string.lastIndexOf("/") + 1, string.length()), xSimpleFileAccess.isFolder(string));
            xMutableTreeNode2.setDataValue(string);
            boolean bl = xSimpleFileAccess.isFolder(string);
            if (xSimpleFileAccess.isFolder(string)) {
                xMutableTreeNode2.setExpandedGraphicURL("private:graphicrepository/sd/res/triangle_down.png");
                xMutableTreeNode2.setCollapsedGraphicURL("private:graphicrepository/sd/res/triangle_right.png");
                String[] stringArray = xSimpleFileAccess.getFolderContents(string, true);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2 = stringArray[i];
                        this.dirlist(string2, xMutableTreeNode2);
                    }
                }
            } else {
                xMutableTreeNode2.setNodeGraphicURL("private:graphicrepository/sw/imglst/nc20010.png");
            }
        }
        catch (CommandAbortedException commandAbortedException) {
            commandAbortedException.printStackTrace();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        try {
            xMutableTreeNode.appendChild(xMutableTreeNode2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    private XAccessibleContext getAccessibleContext(XMutableTreeNode xMutableTreeNode) {
        UITools uITools = new UITools(mxMSF, xTextDoc);
        XWindow xWindow = null;
        try {
            xWindow = uITools.getActiveTopWindow();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UITools uITools2 = new UITools(mxMSF, xWindow);
        uITools2.printAccessibleTree(log, debug);
        return null;
    }

    static {
        debug = false;
    }

    private class execurteDialog
    extends Thread {
        private XDialog mXDialog;

        public execurteDialog(XDialog xDialog) {
            this.mXDialog = xDialog;
        }

        public void run() {
            this.mXDialog.endExecute();
        }
    }
}

