/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleWindow
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    static /* synthetic */ Class class$com$sun$star$awt$XWindow;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        XInterface xInterface = null;
        try {
            printWriter.println("creating a text document");
            xTextDoc = sOfficeFactory.createTextDoc(null);
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XAccessibleContext xAccessibleContext = null;
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40);
        printWriter.println("ImplementationName: " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        final XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                XWindow xWindow = (XWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XWindow == null ? (class$com$sun$star$awt$XWindow = AccessibleWindow.class$("com.sun.star.awt.XWindow")) : class$com$sun$star$awt$XWindow, (Object)xExtendedToolkit.getActiveTopWindow());
                Rectangle rectangle = xWindow.getPosSize();
                rectangle.Width -= 20;
                rectangle.Height -= 20;
                rectangle.X += 20;
                rectangle.Y += 20;
                xWindow.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)15);
            }
        });
        return testEnvironment;
    }
}

