/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.UITools;
import util.dbg;
import util.utils;

public class AccessibleToolBox
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        if (xTextDoc != null) {
            DesktopTools.closeDoc(xTextDoc);
        }
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory(xMultiServiceFactory);
        try {
            printWriter.println("creating a text document");
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XAccessibleContext xAccessibleContext = null;
        UITools uITools = new UITools(xMultiServiceFactory, xModel);
        XWindow xWindow = null;
        try {
            xWindow = uITools.getActiveTopWindow();
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get active top window", exception);
        }
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)63);
        printWriter.println("ImplementationName: " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        testEnvironment.addObjRelation("LimitedBounds", "yes");
        XAccessible xAccessible2 = AccessibilityTools.getAccessibleObject(xAccessibleContext);
        XAccessible xAccessible3 = null;
        try {
            xAccessible3 = xAccessible2.getAccessibleContext().getAccessibleChild(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        dbg.printInterfaces(xAccessible3);
        final XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xAccessible3);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xAccessibleAction.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Couldn't fire event");
                }
            }
        });
        return testEnvironment;
    }
}

