/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleCheckBox
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;
    private static DiagThread psDiag = null;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$frame$XDispatchProvider;
    static /* synthetic */ Class class$com$sun$star$util$XURLTransformer;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        printWriter.println("Creating text document");
        if (xTextDoc == null) {
            try {
                object = SOfficeFactory.getFactory(xMultiServiceFactory);
                xTextDoc = ((SOfficeFactory)object).createTextDoc(null);
            }
            catch (Exception exception) {
                throw new StatusException("Can't create document", exception);
            }
        }
        utils.shortWait(testParameters.getInt("ShortWait"));
        object = null;
        printWriter.println("getting toolkit");
        try {
            object = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, object);
        utils.shortWait(testParameters.getInt("ShortWait"));
        printWriter.println("Opening Dialog in second thread");
        psDiag = new DiagThread(xTextDoc, xMultiServiceFactory);
        psDiag.start();
        utils.shortWait(testParameters.getInt("ShortWait"));
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        utils.shortWait(testParameters.getInt("ShortWait"));
        printWriter.println("Getting the active TopWindow");
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        object = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)44, "Cancel");
        action = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, object);
        object = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)4);
        printWriter.println("ImplementationName " + utils.getImplName(object));
        TestEnvironment testEnvironment = new TestEnvironment((XInterface)object);
        final XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, object);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                System.out.println("Grabbing focus ... ");
                xAccessibleComponent.grabFocus();
            }
        });
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, object);
        testEnvironment.addObjRelation("XAccessibleText.Text", xAccessibleText.getText());
        testEnvironment.addObjRelation("EditOnly", "This method isn't supported in this component");
        testEnvironment.addObjRelation("LimitedBounds", "yes");
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        try {
            printWriter.println("closing dialog");
            action.doAccessibleAction(0);
            printWriter.println("interrupting corresponding Thread");
            psDiag.interrupt();
            printWriter.println("closing the document");
            DesktopTools.closeDoc(xTextDoc);
            printWriter.println("reinitialize the variable");
            xTextDoc = null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Couldn't close dialog");
        }
        catch (DisposedException disposedException) {
            printWriter.println("Dialog already disposed");
        }
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
    }

    public class DiagThread
    extends Thread {
        public XTextDocument xTextDoc = null;
        public XMultiServiceFactory msf = null;

        public DiagThread(XTextDocument xTextDocument, XMultiServiceFactory xMultiServiceFactory) {
            this.xTextDoc = xTextDocument;
            this.msf = xMultiServiceFactory;
        }

        public void run() {
            XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = AccessibleCheckBox.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)this.xTextDoc);
            XController xController = xModel.getCurrentController();
            try {
                String string = ".uno:InsertTable";
                XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(class$com$sun$star$frame$XDispatchProvider == null ? (class$com$sun$star$frame$XDispatchProvider = AccessibleCheckBox.class$("com.sun.star.frame.XDispatchProvider")) : class$com$sun$star$frame$XDispatchProvider, (Object)xController);
                XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(class$com$sun$star$util$XURLTransformer == null ? (class$com$sun$star$util$XURLTransformer = AccessibleCheckBox.class$("com.sun.star.util.XURLTransformer")) : class$com$sun$star$util$XURLTransformer, this.msf.createInstance("com.sun.star.util.URLTransformer"));
                URL[] uRLArray = new URL[]{new URL()};
                uRLArray[0].Complete = string;
                xURLTransformer.parseStrict(uRLArray);
                URL uRL = uRLArray[0];
                XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
                if (xDispatch != null) {
                    xDispatch.dispatch(uRL, null);
                }
            }
            catch (Exception exception) {
                AccessibleCheckBox.this.log.println("Couldn't open dialog");
            }
        }
    }
}

