/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLContentImporter
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        Object object = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.Writer.XMLContentImporter");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object;
        printWriter.println("creating a new environment for Paragraph object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xTextDoc);
        String[][] stringArrayArray = new String[][]{{"start", "office:document-content", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:text", "CDATA", "http://openoffice.org/2000/text"}, {"start", "office:body"}, {"start", "text:p"}, {"chars", "XMLContentImporter test."}, {"end", "text:p"}, {"end", "office:body"}, {"end", "office:document-content"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        final XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xTextDoc);
        final PrintWriter printWriter2 = printWriter;
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                String string = xTextDocument.getText().getString();
                printWriter2.println("Document text returned = '" + string + "'");
                return "XMLContentImporter test.".equals(string);
            }
        });
        return testEnvironment;
    }
}

