/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXTextGraphicObjects
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdoc");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        Object object;
        XInterface xInterface = null;
        Object object2 = null;
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            object2 = sOfficeFactory.createInstance(this.xTextDoc, "com.sun.star.text.GraphicObject");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't create instance");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create instance", exception);
        }
        xInterface = (XInterface)object2;
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface);
        printWriter.println("inserting graphic");
        try {
            xText.insertTextContent(xTextCursor, xTextContent, true);
        }
        catch (Exception exception) {
            System.out.println("Couldn't insert Content");
            exception.printStackTrace();
            throw new StatusException("Couldn't insert Content", exception);
        }
        printWriter.println("adding graphic");
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
        try {
            object = utils.getFullTestURL("space-metal.jpg");
            xPropertySet.setPropertyValue("GraphicURL", object);
            xPropertySet.setPropertyValue("HoriOrientPosition", new Integer(5500));
            xPropertySet.setPropertyValue("VertOrientPosition", new Integer(4200));
            xPropertySet.setPropertyValue("Width", new Integer(4400));
            xPropertySet.setPropertyValue("Height", new Integer(4000));
        }
        catch (Exception exception) {
            System.out.println("Couldn't set property 'GraphicURL'");
            exception.printStackTrace();
            throw new StatusException("Couldn't set property 'GraphicURL'", exception);
        }
        object = (XTextGraphicObjectsSupplier)UnoRuntime.queryInterface(XTextGraphicObjectsSupplier.class, (Object)this.xTextDoc);
        xInterface = object.getGraphicObjects();
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        return testEnvironment;
    }
}

