/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXTextGraphicObject
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdoc");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XInterface xInterface;
        XInterface xInterface2 = null;
        Object object2 = null;
        XTextFrame xTextFrame = null;
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        Object object3 = null;
        try {
            object2 = sOfficeFactory.createInstance(this.xTextDoc, "com.sun.star.text.GraphicObject");
            object3 = sOfficeFactory.createInstance(this.xTextDoc, "com.sun.star.text.GraphicObject");
            xTextFrame = SOfficeFactory.createTextFrame(this.xTextDoc, 500, 500);
        }
        catch (Exception exception) {
            printWriter.println("Couldn't create instance");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create instance", exception);
        }
        xInterface2 = (XInterface)object2;
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface2);
        printWriter.println("inserting Frame");
        try {
            xInterface = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xTextFrame);
            xText.insertTextContent(xTextCursor, (XTextContent)xInterface, true);
        }
        catch (Exception exception) {
            System.out.println("Couldn't insert text frame");
            exception.printStackTrace();
            throw new StatusException("Couldn't insert text frame", exception);
        }
        printWriter.println("inserting graphic");
        try {
            xText.insertTextContent(xTextCursor, xTextContent, true);
        }
        catch (Exception exception) {
            System.out.println("Couldn't insert Content");
            exception.printStackTrace();
            throw new StatusException("Couldn't insert Content", exception);
        }
        printWriter.println("adding graphic");
        xInterface = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface2);
        try {
            object = utils.getFullTestURL("space-metal.jpg");
            xInterface.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
            xInterface.setPropertyValue("GraphicURL", object);
            xInterface.setPropertyValue("HoriOrientPosition", new Integer(5500));
            xInterface.setPropertyValue("VertOrientPosition", new Integer(4200));
            xInterface.setPropertyValue("Width", new Integer(4400));
            xInterface.setPropertyValue("Height", new Integer(4000));
        }
        catch (Exception exception) {
            System.out.println("Couldn't set property 'GraphicURL'");
            exception.printStackTrace();
            throw new StatusException("Couldn't set property 'GraphicURL'", exception);
        }
        object = new TestEnvironment(xInterface2);
        printWriter.println("adding ObjRelation for XShape (get/setPosition won't work there)");
        ((TestEnvironment)object).addObjRelation("NoPos", "SwXTextGraphicObject");
        ((TestEnvironment)object).addObjRelation("NoSetSize", "SwXTextGraphicObject");
        Object object4 = null;
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
            object4 = xMultiServiceFactory.createInstance("com.sun.star.image.ImageMapRectangleObject");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((TestEnvironment)object).addObjRelation("IMGMAP", object4);
        ((TestEnvironment)object).addObjRelation("CONTENT", (XTextContent)UnoRuntime.queryInterface(XTextContent.class, object3));
        ((TestEnvironment)object).addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        ((TestEnvironment)object).addObjRelation("TextFrame", xTextFrame);
        return object;
    }
}

