/*
 * Decompiled with CFR 0.152.
 */
package mod._sm;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class XMLSettingsExporter
extends TestCase {
    XComponent xMathDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a math document");
            this.xMathDoc = sOfficeFactory.createMathDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xMathDoc ");
        this.xMathDoc.dispose();
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        FilterChecker filterChecker = new FilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)filterChecker);
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Math.XMLSettingsExporter", new Object[]{any});
            object = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            object.setSourceDocument(this.xMathDoc);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMathDoc);
            xPropertySet.setPropertyValue("TopMargin", new Short(67));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        filterChecker.addTag(new XMLTools.Tag("office:document-settings"));
        filterChecker.addCharactersEnclosed(String.valueOf(67), new XMLTools.Tag("config:config-item", "config:name", "TopMargin"));
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"smath: StarOffice XML (Math)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", this.xMathDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", filterChecker);
        printWriter.println("Implementation Name: " + utils.getImplName(xInterface));
        return object;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter printWriter) {
            super(printWriter, true);
        }

        public boolean checkFilter() {
            return this.check();
        }
    }
}

