/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdXShape
extends TestCase {
    XComponent xDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a draw document");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        printWriter.println("getting Drawpage");
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xDrawPages);
        XDrawPage xDrawPage = null;
        try {
            xDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", illegalArgumentException);
        }
        printWriter.println("getting Shape");
        XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
        XShape xShape = sOfficeFactory.createShape(this.xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        for (int i = 0; i < 10; ++i) {
            xShapes.add(sOfficeFactory.createShape(this.xDrawDoc, 5000, 3500, 7510 + 10 * i, 5010 + 10 * i, "Rectangle"));
        }
        XShape xShape2 = sOfficeFactory.createShape(this.xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
        xShapes.add(xShape);
        xShapes.add(xShape2);
        printWriter.println("creating a new environment for XShape object");
        TestEnvironment testEnvironment = new TestEnvironment(xShape);
        printWriter.println("adding two style as ObjRelation for ShapeDescriptor");
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xShape);
        XStyle xStyle = null;
        try {
            xStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)xPropertySet.getPropertyValue("Style"));
            xPropertySet.setPropertyValue("ZOrder", new Integer(1));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set or get property value", wrappedTargetException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set or get property value", unknownPropertyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set or get property value", illegalArgumentException);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set or get property value", propertyVetoException);
        }
        testEnvironment.addObjRelation("Style1", xStyle);
        xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xShape2);
        try {
            xStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)xPropertySet.getPropertyValue("Style"));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get property value", wrappedTargetException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get property value", unknownPropertyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get property value", illegalArgumentException);
        }
        testEnvironment.addObjRelation("Style2", xStyle);
        return testEnvironment;
    }
}

