/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.presentation.XCustomPresentationSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdXCustomPresentation
extends TestCase {
    XComponent xImpressDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a draw document");
            this.xImpressDoc = sOfficeFactory.createImpressDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xImpressDoc");
        DesktopTools.closeDoc(this.xImpressDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        printWriter.println("get presentation");
        XCustomPresentationSupplier xCustomPresentationSupplier = (XCustomPresentationSupplier)UnoRuntime.queryInterface(XCustomPresentationSupplier.class, (Object)this.xImpressDoc);
        XNameContainer xNameContainer = xCustomPresentationSupplier.getCustomPresentations();
        XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xNameContainer);
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)xSingleServiceFactory.createInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create instance", exception);
        }
        XNameContainer xNameContainer2 = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameContainer);
        try {
            xNameContainer2.insertByName("FirstPresentation", xInterface);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Could't insert Presentation", wrappedTargetException);
        }
        catch (ElementExistException elementExistException) {
            elementExistException.printStackTrace(printWriter);
            throw new StatusException("Could't insert Presentation", elementExistException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Could't insert Presentation", illegalArgumentException);
        }
        printWriter.println("getting Drawpage");
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xDrawPages);
        XDrawPage xDrawPage = null;
        try {
            xDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", illegalArgumentException);
        }
        XIndexContainer xIndexContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)xInterface);
        try {
            xIndexContainer.insertByIndex(0, xDrawPage);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Could't insert DrawPage", wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Could't insert DrawPage", illegalArgumentException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Could't insert DrawPage", indexOutOfBoundsException);
        }
        printWriter.println("creating a new environment for XPresentation object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        int n = 1;
        if ((String)testParameters.get("THRCNT") != null) {
            n = Integer.parseInt((String)testParameters.get("THRCNT"));
        }
        printWriter.println("adding XIndexContainerINDEX as mod relation to environment");
        testEnvironment.addObjRelation("XIndexContainerINDEX", "0");
        printWriter.println("adding INSTANCEn as mod relation to environment");
        try {
            for (int i = 1; i < 2 * n + 1; ++i) {
                printWriter.println("adding INSTANCE" + i + " as mod relation to environment");
                xDrawPages.insertNewByIndex(0);
                xDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(class$com$sun$star$drawing$XDrawPage == null ? SdXCustomPresentation.class$("com.sun.star.drawing.XDrawPage") : class$com$sun$star$drawing$XDrawPage), (Object)xIndexAccess.getByIndex(0));
                testEnvironment.addObjRelation("INSTANCE" + i, xDrawPage);
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Could't adding INSTANCEn", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Could't adding INSTANCEn", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Could't adding INSTANCEn", illegalArgumentException);
        }
        return testEnvironment;
    }
}

