/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XModifiable;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class DrawController_PresentationView
extends TestCase {
    static XDesktop the_Desk;
    static XComponent xDrawDoc;
    static XComponent xSecondDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing impress documents");
        DesktopTools.closeDoc(xDrawDoc);
        DesktopTools.closeDoc(xSecondDrawDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory(xMultiServiceFactory);
        try {
            printWriter.println("creating two impress documents");
            xSecondDrawDoc = sOfficeFactory.createImpressDoc(null);
            this.shortWait();
            xDrawDoc = sOfficeFactory.createImpressDoc(null);
            this.shortWait();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        printWriter.println("getting Drawpage");
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xDrawDoc);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xDrawPages);
        XDrawPage xDrawPage = null;
        try {
            xDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get DrawPage", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get DrawPage", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get DrawPage", illegalArgumentException);
        }
        printWriter.println("inserting some Shapes");
        XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
        XShape xShape = sOfficeFactory.createShape(xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
        XShape xShape2 = sOfficeFactory.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        XShape xShape3 = sOfficeFactory.createShape(xDrawDoc, 3000, 500, 5000, 1000, "Line");
        xShapes.add(xShape);
        xShapes.add(xShape2);
        xShapes.add(xShape3);
        this.shortWait();
        printWriter.println("switch to PresentationView...");
        try {
            utils.dispatchURL(xMultiServiceFactory, xDrawDoc, ".uno:DiaMode");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException(Status.failed(exception.toString()));
        }
        utils.shortWait(500);
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xDrawDoc);
        XController xController = xModel.getCurrentController();
        printWriter.println("bring first document to front...");
        DesktopTools.bringWindowToFromt(xModel);
        XModel xModel2 = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSecondDrawDoc);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xModel2.getCurrentController());
        printWriter.println("creating a new environment for impress view object");
        TestEnvironment testEnvironment = new TestEnvironment(xController);
        if (xWindow != null) {
            testEnvironment.addObjRelation("XWindow.AnotherWindow", xWindow);
        }
        Object object = null;
        Object object2 = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.drawing.ShapeCollection");
            object2 = xMultiServiceFactory.createInstance("com.sun.star.drawing.ShapeCollection");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException(Status.failed("Couldn't create instance"));
        }
        XShapes xShapes2 = (XShapes)UnoRuntime.queryInterface(XShapes.class, object);
        XShapes xShapes3 = (XShapes)UnoRuntime.queryInterface(XShapes.class, object2);
        xShapes2.add(xShape2);
        xShapes2.add(xShape3);
        xShapes3.add(xShape);
        this.shortWait();
        testEnvironment.addObjRelation("Selections", new Object[]{xDrawPage, object, object2});
        testEnvironment.addObjRelation("Comparer", new Comparator(){

            public int compare(Object object, Object object2) {
                XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = DrawController_PresentationView.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess, object);
                XIndexAccess xIndexAccess2 = (XIndexAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = DrawController_PresentationView.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess, object2);
                if (xIndexAccess == null || xIndexAccess2 == null) {
                    return -1;
                }
                if (xIndexAccess.getCount() == xIndexAccess2.getCount()) {
                    return 0;
                }
                return 1;
            }

            public boolean equals(Object object) {
                return this.compare(this, object) == 0;
            }
        });
        testEnvironment.addObjRelation("Pages", xDrawPages);
        testEnvironment.addObjRelation("FirstModel", xModel);
        testEnvironment.addObjRelation("XUserInputInterception.XModel", xModel);
        XFrame xFrame = the_Desk.getCurrentFrame();
        testEnvironment.addObjRelation("Frame", xFrame);
        xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSecondDrawDoc);
        testEnvironment.addObjRelation("SecondModel", xModel);
        XController xController2 = xModel.getCurrentController();
        testEnvironment.addObjRelation("SecondController", xController2);
        testEnvironment.addObjRelation("XDispatchProvider.URL", "slot:27009");
        XDrawPage xDrawPage2 = xDrawPages.insertNewByIndex(1);
        testEnvironment.addObjRelation("DrawPage", xDrawPage2);
        printWriter.println("Implementation Name: " + utils.getImplName(xController));
        XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)xDrawDoc);
        testEnvironment.addObjRelation("Modifiable", xModifiable);
        testEnvironment.addObjRelation("XComponent.DisposeThis", xDrawDoc);
        return testEnvironment;
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }
}

