/*
 * Decompiled with CFR 0.152.
 */
package mod._sch;

import com.sun.star.awt.Rectangle;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ChXDiagram
extends TestCase {
    XSpreadsheetDocument xSheetDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a sheetdocument");
            this.xSheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    closing xSheetDoc ");
        DesktopTools.closeDoc(this.xSheetDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XSpreadsheet xSpreadsheet = null;
        XChartDocument xChartDocument = null;
        XDiagram xDiagram = null;
        System.out.println("Getting spreadsheet");
        XSpreadsheets xSpreadsheets = this.xSheetDoc.getSheets();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get sheet", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get sheet", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get sheet", illegalArgumentException);
        }
        printWriter.println("Creating the Header");
        ChXDiagram.insertIntoCell(1, 0, "JAN", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(2, 0, "FEB", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(3, 0, "MAR", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(4, 0, "APR", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(5, 0, "MAI", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(6, 0, "JUN", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(7, 0, "JUL", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(8, 0, "AUG", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(9, 0, "SEP", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(10, 0, "OCT", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(11, 0, "NOV", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(12, 0, "DEC", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(13, 0, "SUM", xSpreadsheet, "");
        printWriter.println("Fill the lines");
        ChXDiagram.insertIntoCell(0, 1, "Smith", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(1, 1, "42", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(2, 1, "58.9", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(3, 1, "-66.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(4, 1, "43.4", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(5, 1, "44.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(6, 1, "45.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(7, 1, "-67.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(8, 1, "30.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(9, 1, "23.2", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(10, 1, "-97.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(11, 1, "22.4", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(12, 1, "23.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(13, 1, "=SUM(B2:M2)", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(0, 2, "Jones", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(1, 2, "21", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(2, 2, "40.9", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(3, 2, "-57.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(4, 2, "-23.4", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(5, 2, "34.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(6, 2, "59.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(7, 2, "27.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(8, 2, "-38.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(9, 2, "43.2", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(10, 2, "57.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(11, 2, "25.4", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(12, 2, "28.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(13, 2, "=SUM(B3:M3)", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(0, 3, "Brown", xSpreadsheet, "");
        ChXDiagram.insertIntoCell(1, 3, "31.45", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(2, 3, "-20.9", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(3, 3, "-117.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(4, 3, "23.4", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(5, 3, "-114.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(6, 3, "115.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(7, 3, "-171.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(8, 3, "89.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(9, 3, "41.2", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(10, 3, "71.3", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(11, 3, "25.4", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(12, 3, "38.5", xSpreadsheet, "V");
        ChXDiagram.insertIntoCell(13, 3, "=SUM(A4:L4)", xSpreadsheet, "");
        Rectangle rectangle = new Rectangle(500, 3000, 25000, 11000);
        XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)xSpreadsheet);
        XCellRange xCellRange2 = xCellRange.getCellRangeByName("A1:N4");
        XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)xCellRange2);
        CellRangeAddress cellRangeAddress = xCellRangeAddressable.getRangeAddress();
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[]{cellRangeAddress};
        XTableChartsSupplier xTableChartsSupplier = (XTableChartsSupplier)UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)xSpreadsheet);
        printWriter.println("Insert Chart");
        XTableCharts xTableCharts = xTableChartsSupplier.getCharts();
        if (!xTableCharts.hasByName("ChXDiagram")) {
            xTableCharts.addNewByName("ChXDiagram", rectangle, cellRangeAddressArray, true, true);
        }
        XTableChart xTableChart = null;
        try {
            xTableChart = (XTableChart)AnyConverter.toObject((Type)new Type(XTableChart.class), (Object)((XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xTableCharts)).getByName("ChXDiagram"));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get TableChart", wrappedTargetException);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get TableChart", noSuchElementException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get TableChart", illegalArgumentException);
        }
        XEmbeddedObjectSupplier xEmbeddedObjectSupplier = (XEmbeddedObjectSupplier)UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, (Object)xTableChart);
        XComponent xComponent = xEmbeddedObjectSupplier.getEmbeddedObject();
        xChartDocument = (XChartDocument)UnoRuntime.queryInterface(XChartDocument.class, (Object)xComponent);
        xDiagram = xChartDocument.getDiagram();
        printWriter.println("creating a new environment for chartdocument object");
        TestEnvironment testEnvironment = new TestEnvironment(xDiagram);
        printWriter.println("adding ChartDocument as mod relation to environment");
        testEnvironment.addObjRelation("CHARTDOC", xChartDocument);
        XChartDataArray xChartDataArray = (XChartDataArray)UnoRuntime.queryInterface(XChartDataArray.class, (Object)xChartDocument.getData());
        int n = xChartDataArray.getColumnDescriptions().length;
        int n2 = xChartDataArray.getRowDescriptions().length;
        testEnvironment.addObjRelation("ROWAMOUNT", new Integer(n2));
        testEnvironment.addObjRelation("COLAMOUNT", new Integer(n));
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        XDiagram xDiagram2 = sOfficeFactory.createDiagram(xChartDocument, "StockDiagram");
        testEnvironment.addObjRelation("STOCK", xDiagram2);
        XDiagram xDiagram3 = sOfficeFactory.createDiagram(xChartDocument, "BarDiagram");
        testEnvironment.addObjRelation("BAR", xDiagram3);
        XDiagram xDiagram4 = sOfficeFactory.createDiagram(xChartDocument, "XYDiagram");
        testEnvironment.addObjRelation("LINE", xDiagram4);
        XDiagram xDiagram5 = sOfficeFactory.createDiagram(xChartDocument, "LineDiagram");
        testEnvironment.addObjRelation("STACK", xDiagram5);
        return testEnvironment;
    }

    public static void insertIntoCell(int n, int n2, String string, XSpreadsheet xSpreadsheet, String string2) {
        XCell xCell = null;
        try {
            xCell = xSpreadsheet.getCellByPosition(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Could not get Cell");
        }
        if (string2.equals("V")) {
            xCell.setValue(new Float(string).floatValue());
        } else {
            xCell.setFormula(string);
        }
    }
}

