/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScTableSheetsObj
extends TestCase {
    private static XSpreadsheetDocument xSpreadsheetDoc = null;

    public void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document ", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xSpreadsheetDocument");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        printWriter.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
        XInterface xInterface = (XInterface)UnoRuntime.queryInterface(XInterface.class, (Object)xSpreadsheets);
        printWriter.println("creating a new environment for object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        printWriter.println("creating instance of the sheet object to use it in tests");
        XSpreadsheet xSpreadsheet = null;
        try {
            xSpreadsheet = SOfficeFactory.createSpreadsheet(xSpreadsheetDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create instances", exception);
        }
        testEnvironment.addObjRelation("SecondInstance", xSpreadsheet);
        printWriter.println("adding INSTANCEn as mod relation to environment");
        int n = 1;
        if ((String)testParameters.get("THRCNT") != null) {
            n = Integer.parseInt((String)testParameters.get("THRCNT"));
        }
        try {
            for (int i = 1; i < n + 1; ++i) {
                printWriter.println("adding INSTANCE" + i + " as mod relation to environment");
                testEnvironment.addObjRelation("INSTANCE" + i, SOfficeFactory.createSpreadsheet(xSpreadsheetDoc));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create instances for object relations", exception);
        }
        return testEnvironment;
    }
}

