/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleSpreadsheet
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a Spreadsheet document");
            xSheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XSpreadsheets xSpreadsheets;
        XAccessibleContext xAccessibleContext = null;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)58);
        xAccessibleContext = AccessibilityTools.SearchedContext;
        printWriter.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        XCell xCell = null;
        try {
            xSpreadsheets = xSheetDoc.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
            xCell = xSpreadsheet.getCellByPosition(5, 5);
            xCell.setFormula("Text for testing of the interface XAccessibleText");
        }
        catch (WrappedTargetException wrappedTargetException) {
            printWriter.println("Exception ceating relation :");
            wrappedTargetException.printStackTrace(printWriter);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Exception ceating relation :");
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printWriter.println("Exception ceating relation :");
            illegalArgumentException.printStackTrace(printWriter);
        }
        xSpreadsheets = xCell;
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer((XCell)((Object)xSpreadsheets)){
            private final /* synthetic */ XCell val$fCell;
            {
                this.val$fCell = xCell;
            }

            public void fireEvent() {
                this.val$fCell.setFormula("firing event");
                this.val$fCell.setFormula("Text for testing of the interface XAccessibleText");
            }
        });
        return testEnvironment;
    }
}

