/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.awt.XControlModel;
import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.form.XBoundComponent;
import com.sun.star.form.XForm;
import com.sun.star.form.XLoadable;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.form._XUpdateBroadcaster;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DBTools;
import util.FormTools;
import util.ValueChanger;
import util.ValueComparer;
import util.WriterTools;
import util.utils;

public class GenericModelTest
extends TestCase {
    private static XTextDocument m_xTextDoc;
    private static Object m_dbSrc;
    private static DBTools.DataSourceInfo m_srcInf;
    protected static final String m_dbSourceName = "APITestDatabase";
    protected static final String m_TestDB = "TestDB";
    private DBTools m_dbTools = null;
    private static boolean m_ConnectionColsed;
    public static String m_kindOfControl;
    public static ArrayList m_propertiesToSet;
    public static String m_ChangePropertyName;
    public static Object m_ChangePropertyValue;
    public static String m_ObjectName;
    protected static XLoadable m_XFormLoader;
    protected static XPropertySet m_XPS;
    protected static XInterface m_XCtrl;
    protected static String m_LCShape_Type;
    protected static String m_XPropertyAccess_propertyToChange;
    protected static String m_XPropertyContainer_propertyNotRemovable;
    protected static boolean debug;
    static /* synthetic */ Class class$com$sun$star$form$XBoundComponent;
    static /* synthetic */ Class class$com$sun$star$sdbc$XResultSetUpdate;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a textdocument");
        m_xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
        m_ConnectionColsed = false;
        debug = testParameters.getBool("DebugIsActive");
        m_propertiesToSet.clear();
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XInterface xInterface;
        printWriter.println("closing connection...");
        if (m_ConnectionColsed) {
            return;
        }
        try {
            xInterface = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getForms(WriterTools.getDrawPage(m_xTextDoc)).getByName("Standard"));
            if (debug) {
                if (xInterface == null) {
                    printWriter.println("ERROR: could not get 'Standard' from drawpage!");
                }
                printWriter.println("the draw page contains folowing elemtens:");
                object = FormTools.getForms(WriterTools.getDrawPage(m_xTextDoc)).getElementNames();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    printWriter.println("Element[" + i + "] :" + (String)object[i]);
                }
            }
            object = (String[])UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            XConnection xConnection = (XConnection)AnyConverter.toObject((Type)new Type(XConnection.class), (Object)object.getPropertyValue("ActiveConnection"));
            if (debug && xConnection == null) {
                printWriter.println("ERROR: could not get property 'ActiveConnection' from the XForm");
            }
            xConnection.close();
        }
        catch (Exception exception) {
            printWriter.println("ERROR: Can't close the connection: " + exception.toString());
        }
        printWriter.println("closing data source...");
        try {
            xInterface = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, m_dbSrc);
            if (xInterface == null && (object = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, m_dbSrc)) != null) {
                xInterface = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)object.getDatabaseDocument());
            }
            if (debug && xInterface == null) {
                printWriter.println("ERROR: couldn't get 'XCloseable' from DataSource");
            }
            xInterface.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            printWriter.println("ERROR: couldn't close data source: " + closeVetoException.toString());
        }
        catch (DisposedException disposedException) {
            printWriter.println("ERROR: couldn't close data source: " + disposedException.toString());
        }
        catch (Exception exception) {
            printWriter.println("ERROR: couldn't close data source: " + exception.toString());
        }
        printWriter.println("disposing data source...");
        try {
            xInterface = (XComponent)UnoRuntime.queryInterface(XComponent.class, m_dbSrc);
            xInterface.dispose();
        }
        catch (Exception exception) {
            printWriter.println("couldn't dispose the data source");
        }
        printWriter.println("closing document...");
        try {
            xInterface = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)m_xTextDoc);
            xInterface.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            printWriter.println("ERROR: couldn't close document: " + closeVetoException.toString());
        }
        catch (DisposedException disposedException) {
            printWriter.println("ERROR: couldn't close document: " + disposedException.toString());
        }
        catch (Exception exception) {
            printWriter.println("ERROR: couldn't close document: " + exception.toString());
        }
        printWriter.println("revoking data source...");
        try {
            this.m_dbTools.revokeDB(m_dbSourceName);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (com.sun.star.uno.Exception exception) {
            printWriter.println("ERROR: Error while object test cleaning up: " + exception.toString());
        }
        m_ConnectionColsed = true;
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        Object object2;
        XControlModel xControlModel = null;
        XControlShape xControlShape = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            printWriter.println("adding contol shape '" + m_kindOfControl + "'");
            xControlShape = FormTools.createControlShape(m_xTextDoc, 3000, 4500, 15000, 10000, m_kindOfControl);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create following control shape (m_kindOfControl): '" + m_kindOfControl + "': ", exception);
        }
        WriterTools.getDrawPage(m_xTextDoc).add(xControlShape);
        xControlModel = xControlShape.getControl();
        printWriter.println("Implementation name: " + utils.getImplName(xControlModel));
        try {
            object2 = utils.getFullURL(utils.getFullTestDocName("TestDB/testDB.dbf"));
            String string = utils.getOfficeTemp(xMultiServiceFactory);
            string = utils.getFullURL(string + "testDB.dbf");
            printWriter.println("copy '" + (String)object2 + "' -> '" + string + "'");
            utils.copyFile(xMultiServiceFactory, (String)object2, string);
            this.m_dbTools = new DBTools(xMultiServiceFactory);
            object = utils.getOfficeTemp(xMultiServiceFactory);
            m_srcInf = this.m_dbTools.newDataSourceInfo();
            GenericModelTest.m_srcInf.URL = "sdbc:dbase:" + DBTools.dirToUrl((String)object);
            printWriter.println("data source: " + GenericModelTest.m_srcInf.URL);
            m_dbSrc = m_srcInf.getDataSourceService();
            this.m_dbTools.reRegisterDB(m_dbSourceName, m_dbSrc);
            m_XFormLoader = FormTools.bindForm(m_xTextDoc, m_dbSourceName, m_TestDB);
        }
        catch (com.sun.star.uno.Exception exception) {
            printWriter.println("!!! Can't access TestDB !!!");
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't access TestDB", exception);
        }
        printWriter.println("creating a new environment for object");
        object2 = new TestEnvironment(xControlModel);
        ((TestEnvironment)object2).addObjRelation("OBJNAME", m_ObjectName);
        printWriter.println("adding shape '" + m_LCShape_Type + "' for DataAwareControlModel test");
        xControlShape = FormTools.createControlShape(m_xTextDoc, 6000, 4500, 15000, 10000, m_LCShape_Type);
        WriterTools.getDrawPage(m_xTextDoc).add(xControlShape);
        m_XPS = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlModel);
        int n = 0;
        object = null;
        try {
            for (n = 0; n < m_propertiesToSet.size(); ++n) {
                object = (NamedValue)m_propertiesToSet.get(n);
                printWriter.println("setting property: '" + ((NamedValue)object).Name + "' to value '" + ((NamedValue)object).Value.toString() + "'");
                m_XPS.setPropertyValue(((NamedValue)object).Name, ((NamedValue)object).Value);
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set property '" + ((NamedValue)object).Name + "': ", wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set property '" + ((NamedValue)object).Name + "': ", illegalArgumentException);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set property '" + ((NamedValue)object).Name + "': ", propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(printWriter);
            throw new StatusException("Couldn't set property '" + ((NamedValue)object).Name + "': ", unknownPropertyException);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get property on index '" + n + "': ", classCastException);
        }
        ((TestEnvironment)object2).addObjRelation("LC", xControlShape.getControl());
        ((TestEnvironment)object2).addObjRelation("FL", m_XFormLoader);
        m_XCtrl = xControlModel;
        ((TestEnvironment)object2).addObjRelation("XUpdateBroadcaster.Checker", new Checker(m_XFormLoader, m_XPS, m_XCtrl, m_ChangePropertyName, m_ChangePropertyValue));
        ((TestEnvironment)object2).addObjRelation("DataAwareControlModel.NewFieldName", "_DATE");
        ((TestEnvironment)object2).addObjRelation("PSEUDOPERSISTENT", new Boolean(true));
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("FormatKey");
        ((TestEnvironment)object2).addObjRelation("XFastPropertySet.ExcludeProps", hashSet);
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = m_XPropertyAccess_propertyToChange;
        propertyValue.Value = "Text since XPropertyAccess";
        ((TestEnvironment)object2).addObjRelation("XPropertyAccess.propertyToChange", propertyValue);
        ((TestEnvironment)object2).addObjRelation("XPropertyContainer.propertyNotRemovable", m_XPropertyContainer_propertyNotRemovable);
        return object2;
    }

    static {
        m_dbSrc = null;
        m_srcInf = null;
        m_ConnectionColsed = false;
        m_kindOfControl = null;
        m_propertiesToSet = new ArrayList();
        m_ChangePropertyName = null;
        m_ChangePropertyValue = null;
        m_ObjectName = null;
        m_XFormLoader = null;
        m_XPS = null;
        m_XCtrl = null;
        m_LCShape_Type = null;
        m_XPropertyAccess_propertyToChange = "HelpText";
        m_XPropertyContainer_propertyNotRemovable = "HelpText";
        debug = false;
    }

    static class Checker
    implements _XUpdateBroadcaster.UpdateChecker {
        private Object lastValue = null;
        XLoadable formLoaderF = null;
        XPropertySet ps = null;
        XInterface ctrl = null;
        String ChangePropertyName = null;
        Object ChangePropertyValue = null;

        public Checker(XLoadable xLoadable, XPropertySet xPropertySet, XInterface xInterface, String string, Object object) {
            this.formLoaderF = xLoadable;
            this.ps = xPropertySet;
            this.ctrl = xInterface;
            this.ChangePropertyName = string;
            this.ChangePropertyValue = object;
        }

        public void update() throws com.sun.star.uno.Exception {
            if (!this.formLoaderF.isLoaded()) {
                this.formLoaderF.load();
            }
            this.lastValue = ValueChanger.changePValue(this.ps.getPropertyValue(this.ChangePropertyName));
            if (this.lastValue == null) {
                if (this.ChangePropertyValue != null) {
                    this.lastValue = this.ChangePropertyValue;
                } else {
                    String string = "The initial value of the property '" + this.ChangePropertyName + "' is NULL\n";
                    string = string + "The member variable 'm_ChangePropertyValue' is NULL\n";
                    string = string + "Could not change Property.";
                    throw new StatusException(Status.failed(string));
                }
            }
            this.ps.setPropertyValue(this.ChangePropertyName, this.lastValue);
        }

        public void commit() throws SQLException {
            XBoundComponent xBoundComponent = (XBoundComponent)UnoRuntime.queryInterface(class$com$sun$star$form$XBoundComponent == null ? (class$com$sun$star$form$XBoundComponent = GenericModelTest.class$("com.sun.star.form.XBoundComponent")) : class$com$sun$star$form$XBoundComponent, (Object)this.ctrl);
            XResultSetUpdate xResultSetUpdate = (XResultSetUpdate)UnoRuntime.queryInterface(class$com$sun$star$sdbc$XResultSetUpdate == null ? (class$com$sun$star$sdbc$XResultSetUpdate = GenericModelTest.class$("com.sun.star.sdbc.XResultSetUpdate")) : class$com$sun$star$sdbc$XResultSetUpdate, (Object)this.formLoaderF);
            xBoundComponent.commit();
            xResultSetUpdate.updateRow();
        }

        public boolean wasCommited() throws com.sun.star.uno.Exception {
            this.formLoaderF.reload();
            Object object = this.ps.getPropertyValue(this.ChangePropertyName);
            return object != null && ValueComparer.equalValue(this.lastValue, object);
        }
    }
}

