/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class ODatabaseContext
extends TestCase {
    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        Object object = null;
        XMultiServiceFactory xMultiServiceFactory = null;
        try {
            xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
            object = xMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
        }
        catch (Exception exception) {
            printWriter.println("Service not available");
            throw new StatusException("Service not available", exception);
        }
        if (object == null) {
            printWriter.println("Service wasn't created");
            throw new StatusException(Status.failed("Service wasn't created"));
        }
        xInterface = (XInterface)object;
        printWriter.println("    creating a new environment for object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        try {
            xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
            object = xMultiServiceFactory.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object);
            xPropertySet.setPropertyValue("URL", "sdbc:dbase:file:///.");
            XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, object);
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xDocumentDataSource.getDatabaseDocument());
            String string = utils.getOfficeTemp((XMultiServiceFactory)testParameters.getMSF()) + "DatabaseContext.odb";
            printWriter.println("store to '" + string + "'");
            xStorable.storeAsURL(string, new PropertyValue[0]);
            testEnvironment.addObjRelation("XNamingService.RegisterObject", object);
            testEnvironment.addObjRelation("INSTANCE", object);
            testEnvironment.addObjRelation("XContainer.Container", (XNamingService)UnoRuntime.queryInterface(XNamingService.class, (Object)xInterface));
        }
        catch (Exception exception) {
            throw new StatusException("Can't create object relation", exception);
        }
        catch (NullPointerException nullPointerException) {
            throw new StatusException("Can't create object relation", nullPointerException);
        }
        return testEnvironment;
    }
}

