/*
 * Decompiled with CFR 0.152.
 */
package ifc.view;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.view.XMultiSelectionSupplier;
import java.util.Comparator;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XMultiSelectionSupplier
extends MultiMethodTest {
    public XMultiSelectionSupplier oObj = null;
    public boolean selectionChanged = false;
    Object[] selections = null;
    Comparator ObjCompare = null;

    protected void before() {
        this.selections = (Object[])this.tEnv.getObjRelation("Selections");
        if (this.selections == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'Selections'"));
        }
        this.ObjCompare = (Comparator)this.tEnv.getObjRelation("Comparer");
    }

    protected void after() {
        this.disposeEnvironment();
    }

    public void _addSelection() {
        boolean bl = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int n = this.oObj.getSelectionCount();
        if (!(bl &= n == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + n + "' => FAILED");
        }
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + illegalArgumentException.toString());
                bl = false;
            }
            n = this.oObj.getSelectionCount();
            if (n == i + 1) continue;
            this.log.println("ERROR: add a selection but selection count (" + n + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bl = false;
        }
        this.log.println("try to select object relation 'selections[0]' second time...");
        try {
            n = this.oObj.getSelectionCount();
            this.oObj.addSelection(this.selections[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("ERROR: could not add selection from object relation 'selections[0] a second time': " + illegalArgumentException.toString());
        }
        if (n != this.oObj.getSelectionCount()) {
            this.log.println("ERROR: the selected count (" + this.oObj.getSelectionCount() + ") is not that before (" + n + ")");
            bl = false;
        }
        this.log.println("try to select invalid object...");
        try {
            this.oObj.addSelection(this.oObj);
            this.log.println("ERORR: expected exception 'com.sun.star.lang.IllegalArgumentException' was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected exception 'com.sun.star.lang.IllegalArgumentException' => OK");
        }
        this.tRes.tested("addSelection()", bl);
    }

    public void _removeSelection() {
        int n;
        this.requiredMethod("addSelection()");
        boolean bl = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int n2 = this.oObj.getSelectionCount();
        if (!(bl &= n2 == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + n2 + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (n = 0; n < this.selections.length; ++n) {
            try {
                this.log.println("select object from object relation 'selections[" + n + "]'");
                this.oObj.addSelection(this.selections[n]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + n + "]': " + illegalArgumentException.toString());
                bl = false;
            }
            n2 = this.oObj.getSelectionCount();
            if (n2 == n + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + n2 + ") " + "is not as expected (" + (n + 1) + ") => FAILED");
            bl = false;
        }
        this.log.println("try now to remove selections...");
        n2 = this.oObj.getSelectionCount();
        n = this.oObj.getSelectionCount();
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("remove selection for object relation 'selections[" + i + "]'");
                this.oObj.removeSelection(this.selections[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("ERROR: could not remove selection from object relation 'selections[" + i + "]': " + illegalArgumentException.toString());
                bl = false;
            }
            n2 = this.oObj.getSelectionCount();
            if (n2 == n - i - 1) continue;
            this.log.println("ERROR: removed a selection but selection count (" + n2 + ") " + "is not as expected (" + (n - i - 1) + ") => FAILED");
            bl = false;
        }
        this.log.println("try to remove a removed selection a second time...");
        n2 = this.oObj.getSelectionCount();
        try {
            this.oObj.removeSelection(this.selections[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("ERROR: could not remove selection from object relation 'selections[0] a second time': " + illegalArgumentException.toString());
        }
        if (n2 != this.oObj.getSelectionCount()) {
            this.log.println("ERROR: the selected count (" + this.oObj.getSelectionCount() + ") is not that before (" + n2 + ")");
            bl = false;
        }
        this.log.println("try to remove invalid object...");
        try {
            this.oObj.removeSelection(this.oObj);
            this.log.println("ERORR: expected exception 'com.sun.star.lang.IllegalArgumentException' was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected exception 'com.sun.star.lang.IllegalArgumentException' => OK");
        }
        this.tRes.tested("removeSelection()", bl);
    }

    public void _getSelectionCount() {
        this.requiredMethod("addSelection()");
        this.tRes.tested("getSelectionCount()", true);
    }

    public void _clearSelection() {
        this.requiredMethod("addSelection()");
        boolean bl = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int n = this.oObj.getSelectionCount();
        if (!(bl &= n == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + n + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + illegalArgumentException.toString());
                bl = false;
            }
            n = this.oObj.getSelectionCount();
            if (n == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + n + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bl = false;
        }
        n = this.oObj.getSelectionCount();
        this.log.println("clear selections...");
        this.oObj.clearSelection();
        n = this.oObj.getSelectionCount();
        if (!(bl &= n == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + n + "' => FAILED");
        }
        this.tRes.tested("clearSelection()", bl);
    }

    public void _createSelectionEnumeration() {
        this.requiredMethod("addSelection()");
        boolean bl = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int n = this.oObj.getSelectionCount();
        if (!(bl &= n == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + n + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + illegalArgumentException.toString());
                bl = false;
            }
            n = this.oObj.getSelectionCount();
            if (n == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + n + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bl = false;
        }
        this.log.println("create enumeration...");
        XEnumeration xEnumeration = this.oObj.createSelectionEnumeration();
        boolean bl2 = true;
        int n2 = 0;
        while (xEnumeration.hasMoreElements()) {
            this.log.println("try to get first element..");
            Object object = null;
            try {
                object = xEnumeration.nextElement();
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println("ERROR: could not get nextElement: " + wrappedTargetException.toString());
                bl = false;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.log.println("ERROR: could not get nextElement: " + noSuchElementException.toString());
                bl = false;
            }
            Object object2 = this.selections[n2];
            ++n2;
            if (this.ObjCompare != null) {
                this.ObjCompare.compare(object2, object);
            } else {
                bl2 = ValueComparer.equalValue(object2, object);
            }
            this.log.println("nextElement()-object and expected object 'selections[" + n2 + "]' are equal: " + bl2);
            if (!bl2 && this.selections[n2] instanceof Object[] && ((Object[])this.selections[n2])[0] instanceof Integer) {
                this.log.println("Getting: " + (Integer)((Object[])object2)[0]);
                this.log.println("Expected: " + (Integer)((Object[])this.selections[n2])[0]);
            }
            bl &= bl2;
        }
        this.tRes.tested("createSelectionEnumeration()", bl);
    }

    public void _createReverseSelectionEnumeration() {
        this.requiredMethod("addSelection()");
        boolean bl = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int n = this.oObj.getSelectionCount();
        if (!(bl &= n == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + n + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + illegalArgumentException.toString());
                bl = false;
            }
            n = this.oObj.getSelectionCount();
            if (n == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + n + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bl = false;
        }
        this.log.println("create enumeration...");
        XEnumeration xEnumeration = this.oObj.createSelectionEnumeration();
        boolean bl2 = true;
        int n2 = this.selections.length - 1;
        while (xEnumeration.hasMoreElements()) {
            this.log.println("try to get first element..");
            Object object = null;
            try {
                object = xEnumeration.nextElement();
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println("ERROR: could not get nextElement: " + wrappedTargetException.toString());
                bl = false;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.log.println("ERROR: could not get nextElement: " + noSuchElementException.toString());
                bl = false;
            }
            Object object2 = this.selections[n2];
            --n2;
            if (this.ObjCompare != null) {
                this.ObjCompare.compare(object2, object);
            } else {
                bl2 = ValueComparer.equalValue(object2, object);
            }
            this.log.println("nextElement()-object and expected object 'selections[" + n2 + "]' are equal: " + bl2);
            if (!bl2 && this.selections[n2] instanceof Object[] && ((Object[])this.selections[n2])[0] instanceof Integer) {
                this.log.println("Getting: " + (Integer)((Object[])object2)[0]);
                this.log.println("Expected: " + (Integer)((Object[])this.selections[n2])[0]);
            }
            bl &= bl2;
        }
        this.tRes.tested("createReverseSelectionEnumeration()", bl);
    }
}

