/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui.dialogs;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.ui.dialogs.XControlInformation;
import lib.MultiMethodTest;

public class _XControlInformation
extends MultiMethodTest {
    public XControlInformation oObj = null;
    private String[] supControls = null;
    private String[][] supProperties = null;

    public void _getSupportedControls() {
        this.supControls = this.oObj.getSupportedControls();
        this.tRes.tested("getSupportedControls()", this.supControls != null);
    }

    public void _isControlSupported() {
        this.requiredMethod("getSupportedControls()");
        boolean bl = true;
        this.log.println("Supported controls :");
        for (int i = 0; i < this.supControls.length; ++i) {
            this.log.println("  " + this.supControls[i]);
            bl &= this.oObj.isControlSupported(this.supControls[i]);
        }
        bl &= !this.oObj.isControlSupported("SuchNameMustNotExist");
        this.tRes.tested("isControlSupported()", bl &= !this.oObj.isControlSupported(""));
    }

    public void _getSupportedControlProperties() {
        this.requiredMethod("getSupportedControls()");
        boolean bl = true;
        this.supProperties = new String[this.supControls.length][];
        for (int i = 0; i < this.supControls.length; ++i) {
            this.log.println("Getting proeprties for control: " + this.supControls[i]);
            try {
                this.supProperties[i] = this.oObj.getSupportedControlProperties(this.supControls[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("Unexpected exception:" + illegalArgumentException);
                bl = false;
            }
            bl &= this.supProperties[i] != null;
        }
        try {
            String[] stringArray = this.oObj.getSupportedControlProperties("NoSuchControl");
            bl &= stringArray == null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Expected exception getting properties for wrong control:" + illegalArgumentException);
        }
        this.tRes.tested("getSupportedControlProperties()", true);
    }

    public void _isControlPropertySupported() {
        this.requiredMethod("getSupportedControlProperties()");
        boolean bl = true;
        for (int i = 0; i < this.supControls.length; ++i) {
            this.log.println("Checking proeprties for control " + this.supControls[i]);
            for (int j = 0; j < this.supProperties[i].length; ++j) {
                this.log.println("   " + this.supProperties[i][j]);
                try {
                    bl &= this.oObj.isControlPropertySupported(this.supControls[i], this.supProperties[i][j]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.println("Unexpected exception:" + illegalArgumentException);
                    bl = false;
                }
            }
            try {
                bl &= !this.oObj.isControlPropertySupported(this.supControls[i], "NoSuchPropertyForThisControl");
                bl &= !this.oObj.isControlPropertySupported(this.supControls[i], "");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("Unexpected exception (just false must be returned):" + illegalArgumentException);
                bl = false;
            }
        }
        try {
            bl &= !this.oObj.isControlPropertySupported("NoSuchControl", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Expected exception: " + illegalArgumentException);
        }
        this.tRes.tested("isControlPropertySupported()", bl);
    }
}

