/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ui.XContextMenuInterception;
import com.sun.star.ui.XContextMenuInterceptor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import helper.ContextMenuInterceptor;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.AccessibilityTools;
import util.DesktopTools;
import util.utils;

public class _XContextMenuInterception
extends MultiMethodTest {
    private XModel docModel = null;
    private XContextMenuInterceptor xCI = null;
    public XContextMenuInterception oObj = null;
    private XWindow xWindow = null;
    private XMultiServiceFactory xMSF = null;
    private Point point = null;

    public void before() {
        this.docModel = (XModel)UnoRuntime.queryInterface(XModel.class, this.tEnv.getObjRelation("FirstModel"));
        this.xCI = (XContextMenuInterceptor)UnoRuntime.queryInterface(XContextMenuInterceptor.class, (Object)new ContextMenuInterceptor());
        this.xMSF = (XMultiServiceFactory)this.tParam.getMSF();
        this.log.println("ensure that the first model is focused");
        DesktopTools.bringWindowToFromt(this.docModel);
        utils.shortWait(3000);
    }

    public void after() {
        if (this.xCI != null) {
            this.oObj.releaseContextMenuInterceptor(this.xCI);
        }
    }

    public void _registerContextMenuInterceptor() {
        this.oObj.registerContextMenuInterceptor(this.xCI);
        this.openContextMenu(this.docModel);
        boolean bl = this.checkHelpEntry();
        this.releasePopUp();
        this.tRes.tested("registerContextMenuInterceptor()", bl);
    }

    public void _releaseContextMenuInterceptor() {
        this.requiredMethod("registerContextMenuInterceptor()");
        this.oObj.releaseContextMenuInterceptor(this.xCI);
        this.openContextMenu(this.docModel);
        boolean bl = this.checkHelpEntry();
        this.releasePopUp();
        this.tRes.tested("releaseContextMenuInterceptor()", !bl);
    }

    private boolean checkHelpEntry() {
        XInterface xInterface = null;
        boolean bl = true;
        this.log.println("get accesibility...");
        try {
            xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            this.log.println("could not get Toolkit " + exception.toString());
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        XAccessible xAccessible = null;
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        try {
            this.xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getTopWindow(0));
            xAccessible = AccessibilityTools.getAccessibleObject(this.xWindow);
            AccessibilityTools.printAccessibleTree(this.log, xAccessible, this.tParam.getBool("DebugIsActive"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Couldn't get Window");
        }
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)43, true);
        this.log.println("ImplementationName: " + utils.getImplName(xAccessibleContext));
        XAccessible xAccessible2 = null;
        try {
            this.log.println("Try to get second entry of context menu...");
            xAccessible2 = xAccessibleContext.getAccessibleChild(1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new StatusException("Not possible to get second entry of context menu", indexOutOfBoundsException);
        }
        if (xAccessible2 == null) {
            throw new StatusException(new Status("second entry of context menu is NULL", false));
        }
        XAccessibleContext xAccessibleContext2 = xAccessible2.getAccessibleContext();
        if (xAccessibleContext2 == null) {
            throw new StatusException(new Status("No able to retrieve accessible context from first entry of context menu", false));
        }
        String string = xAccessibleContext2.getAccessibleName();
        if (!string.equals("Help")) {
            this.log.println("Accessible name found = " + string);
            this.log.println("Second entry of context menu is not from context menu interceptor");
            bl = false;
        }
        return bl;
    }

    private void openContextMenu(XModel xModel) {
        this.log.println("try to open contex menu...");
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        this.xWindow = AccessibilityTools.getCurrentWindow(this.xMSF, xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(this.xWindow);
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40);
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        this.point = xAccessibleComponent.getLocationOnScreen();
        Rectangle rectangle = xAccessibleComponent.getBounds();
        this.log.println("klick mouse button...");
        try {
            Robot robot = new Robot();
            int n = this.point.X + rectangle.Width / 2;
            int n2 = this.point.Y + rectangle.Height / 2;
            robot.mouseMove(n, n2);
            System.out.println("Press Button");
            robot.mousePress(4);
            System.out.println("Release Button");
            robot.mouseRelease(4);
            System.out.println("done");
        }
        catch (AWTException aWTException) {
            this.log.println("couldn't press mouse button");
        }
        utils.shortWait(1000);
    }

    private void releasePopUp() {
        this.log.println("release the popup menu");
        try {
            Robot robot = new Robot();
            int n = this.point.X;
            int n2 = this.point.Y;
            robot.mouseMove(n, n2);
            robot.mousePress(16);
            robot.mouseRelease(16);
        }
        catch (AWTException aWTException) {
            this.log.println("couldn't press mouse button");
        }
    }
}

