/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.DataPilotFieldFilter;
import com.sun.star.sheet.DataPilotFieldOrientation;
import com.sun.star.sheet.DataPilotTableHeaderData;
import com.sun.star.sheet.DataPilotTablePositionData;
import com.sun.star.sheet.DataPilotTableResultData;
import com.sun.star.sheet.DataResult;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XDataPilotDescriptor;
import com.sun.star.sheet.XDataPilotTable2;
import com.sun.star.sheet.XSheetCellCursor;
import com.sun.star.sheet.XSheetCellRange;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellCursor;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataPilotTable2
extends MultiMethodTest {
    private XSpreadsheetDocument xSheetDoc = null;
    private XDataPilotTable2 xDPTab2 = null;
    private CellRangeAddress mRangeWhole = null;
    private CellRangeAddress mRangeTable = null;
    private CellRangeAddress mRangeResult = null;
    private ArrayList mDataFieldDims = null;
    private ArrayList mResultCells = null;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheet;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    protected void before() {
        Object object = this.tEnv.getObjRelation("DATAPILOTTABLE2");
        this.xDPTab2 = (XDataPilotTable2)UnoRuntime.queryInterface(XDataPilotTable2.class, object);
        if (this.xDPTab2 == null) {
            throw new StatusException(Status.failed("Relation not found"));
        }
        this.xSheetDoc = (XSpreadsheetDocument)this.tEnv.getObjRelation("SHEETDOCUMENT");
        this.getOutputRanges();
        this.buildDataFields();
        try {
            this.buildResultCells();
        }
        catch (ResultCellFailure resultCellFailure) {
            resultCellFailure.printStackTrace(this.log);
            throw new StatusException("Failed to build result cells.", resultCellFailure);
        }
    }

    public void _getDrillDownData() {
        boolean bl = true;
        int n = this.mResultCells.size();
        for (int i = 0; i < n; ++i) {
            CellAddress cellAddress = (CellAddress)this.mResultCells.get(i);
            DataPilotTablePositionData dataPilotTablePositionData = this.xDPTab2.getPositionData(cellAddress);
            DataPilotTableResultData dataPilotTableResultData = (DataPilotTableResultData)dataPilotTablePositionData.PositionData;
            int n2 = (Integer)this.mDataFieldDims.get(dataPilotTableResultData.DataFieldIndex);
            DataResult dataResult = dataPilotTableResultData.Result;
            double d = dataResult.Value;
            Object[][] objectArray = this.xDPTab2.getDrillDownData(cellAddress);
            double d2 = 0.0;
            if (objectArray.length > 1) {
                for (int j = 1; j < objectArray.length; ++j) {
                    Object object = objectArray[j][n2];
                    if (!AnyConverter.isDouble((Object)object)) continue;
                    d2 += ((Double)object).doubleValue();
                }
            }
            this.log.println(this.formatCell(cellAddress) + ": " + objectArray.length + " rows (" + (objectArray.length - 1) + " records)");
            if (d == d2) continue;
            bl = false;
        }
        this.tRes.tested("getDrillDownData()", bl);
    }

    public void _getPositionData() {
        boolean bl = false;
        CellAddress cellAddress = new CellAddress();
        cellAddress.Sheet = this.mRangeTable.Sheet;
        boolean bl2 = true;
        for (int i = this.mRangeTable.StartColumn; i <= this.mRangeTable.EndColumn && bl2; ++i) {
            block8: for (int j = this.mRangeTable.StartRow; j <= this.mRangeTable.EndRow && bl2; ++j) {
                cellAddress.Column = i;
                cellAddress.Row = j;
                this.log.println("checking " + this.formatCell(cellAddress));
                DataPilotTablePositionData dataPilotTablePositionData = this.xDPTab2.getPositionData(cellAddress);
                if (dataPilotTablePositionData.PositionType == 0) {
                    this.log.println("specified cell address not in table: " + this.formatCell(cellAddress));
                    bl2 = false;
                    continue;
                }
                switch (dataPilotTablePositionData.PositionType) {
                    case 0: {
                        continue block8;
                    }
                    case 3: {
                        this.printHeaderData(dataPilotTablePositionData);
                        continue block8;
                    }
                    case 2: {
                        this.printHeaderData(dataPilotTablePositionData);
                        continue block8;
                    }
                    case 1: {
                        this.printResultData(dataPilotTablePositionData);
                        continue block8;
                    }
                    case 4: {
                        continue block8;
                    }
                    default: {
                        this.log.println("unknown position");
                    }
                }
            }
        }
        if (!bl2) {
            this.log.println("table range check failed");
        } else {
            bl = true;
        }
        this.tRes.tested("getPositionData()", bl);
    }

    public void _insertDrillDownSheet() {
        boolean bl = true;
        int n = this.mResultCells.size();
        XSpreadsheets xSpreadsheets = this.xSheetDoc.getSheets();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        int n2 = xIndexAccess.getCount();
        for (int i = 0; i < n && bl; ++i) {
            CellAddress cellAddress = (CellAddress)this.mResultCells.get(i);
            Object[][] objectArray = this.xDPTab2.getDrillDownData(cellAddress);
            this.xDPTab2.insertDrillDownSheet(cellAddress);
            int n3 = xIndexAccess.getCount();
            if (n3 == n2 + 1) {
                this.log.println("drill-down sheet for " + this.formatCell(cellAddress) + " inserted");
                if (objectArray.length < 2) {
                    this.log.println("new sheet inserted; however, there is no data for this result");
                    bl = false;
                    continue;
                }
                XSpreadsheet xSpreadsheet = null;
                try {
                    xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface(class$com$sun$star$sheet$XSpreadsheet == null ? _XDataPilotTable2.class$("com.sun.star.sheet.XSpreadsheet") : class$com$sun$star$sheet$XSpreadsheet, xIndexAccess.getByIndex(cellAddress.Sheet));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new StatusException("Failed to get the spreadsheet object.", exception);
                }
                if (!this.checkDrillDownSheetContent(xSpreadsheet, objectArray)) {
                    this.log.println("dataintegrity check on the inserted sheet failed");
                    bl = false;
                    continue;
                }
                this.log.println("  sheet data integrity check passed");
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(class$com$sun$star$container$XNamed == null ? _XDataPilotTable2.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed, (Object)xSpreadsheet);
                String string = xNamed.getName();
                try {
                    xSpreadsheets.removeByName(string);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new StatusException("Failed to removed the inserted sheet named " + string + ".", exception);
                }
            }
            if (n3 == n2) {
                if (objectArray.length <= 1) continue;
                this.log.println("no new sheet is inserted, despite the data being present.");
                bl = false;
                continue;
            }
            this.log.println("what just happened!?");
            bl = false;
        }
        this.tRes.tested("insertDrillDownSheet()", bl);
    }

    public void _getOutputRangeByType() {
        boolean bl;
        block6: {
            bl = false;
            try {
                CellRangeAddress cellRangeAddress = this.xDPTab2.getOutputRangeByType(-1);
                this.log.println("exception not raised");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("exception raised on invalid range type (good)");
                try {
                    CellRangeAddress cellRangeAddress = this.xDPTab2.getOutputRangeByType(100);
                    this.log.println("exception not raised");
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    this.log.println("exception raised on invalid range type (good)");
                    if (this.mRangeWhole.EndColumn - this.mRangeWhole.StartColumn <= 0 || this.mRangeWhole.EndRow - this.mRangeWhole.EndColumn <= 0) {
                        this.log.println("whole range is empty");
                        break block6;
                    }
                    this.log.println("whole range is not empty (good)");
                    if (this.mRangeTable.Sheet != this.mRangeWhole.Sheet || this.mRangeTable.StartColumn != this.mRangeWhole.StartColumn || this.mRangeTable.EndColumn != this.mRangeWhole.EndColumn || this.mRangeTable.EndRow != this.mRangeWhole.EndRow) {
                        this.log.println("table range is incorrect");
                        break block6;
                    }
                    this.log.println("table range is correct");
                    if (this.mRangeResult.Sheet != this.mRangeTable.Sheet || this.mRangeResult.StartColumn < this.mRangeTable.StartColumn || this.mRangeResult.StartRow < this.mRangeTable.StartRow || this.mRangeResult.EndColumn != this.mRangeTable.EndColumn || this.mRangeResult.EndRow != this.mRangeTable.EndRow) break block6;
                    this.log.println("result range is correct");
                    bl = true;
                }
            }
        }
        this.tRes.tested("getOutputRangeByType()", bl);
    }

    private void printHeaderData(DataPilotTablePositionData dataPilotTablePositionData) {
        DataPilotTableHeaderData dataPilotTableHeaderData = (DataPilotTableHeaderData)dataPilotTablePositionData.PositionData;
        String string = "";
        if (dataPilotTablePositionData.PositionType == 3) {
            string = "column header";
        } else if (dataPilotTablePositionData.PositionType == 2) {
            string = "row header";
        }
        this.log.println(string + "; member name: " + dataPilotTableHeaderData.MemberName + "; dimension: " + dataPilotTableHeaderData.Dimension + "; hierarchy: " + dataPilotTableHeaderData.Hierarchy + "; level: " + dataPilotTableHeaderData.Level);
    }

    private void printResultData(DataPilotTablePositionData dataPilotTablePositionData) {
        DataPilotTableResultData dataPilotTableResultData = (DataPilotTableResultData)dataPilotTablePositionData.PositionData;
        int n = dataPilotTableResultData.DataFieldIndex;
        DataResult dataResult = dataPilotTableResultData.Result;
        double d = dataResult.Value;
        int n2 = dataResult.Flags;
        int n3 = dataPilotTableResultData.FieldFilters.length;
        this.log.println("result; data field index: " + n + "; value: " + d + "; flags: " + n2 + "; filter count: " + n3);
        for (int i = 0; i < n3; ++i) {
            DataPilotFieldFilter dataPilotFieldFilter = dataPilotTableResultData.FieldFilters[i];
            this.log.println("  field name: " + dataPilotFieldFilter.FieldName + "; match value: " + dataPilotFieldFilter.MatchValue);
        }
    }

    private String formatCell(CellAddress cellAddress) {
        String string = "(" + cellAddress.Column + "," + cellAddress.Row + ")";
        return string;
    }

    private void printRange(String string, CellRangeAddress cellRangeAddress) {
        this.log.println(string + ": (" + cellRangeAddress.StartColumn + "," + cellRangeAddress.StartRow + ") - (" + cellRangeAddress.EndColumn + "," + cellRangeAddress.EndRow + ")");
    }

    private void buildResultCells() throws ResultCellFailure {
        if (this.mResultCells != null) {
            return;
        }
        this.getOutputRanges();
        this.mResultCells = new ArrayList();
        for (int i = this.mRangeResult.StartColumn; i <= this.mRangeResult.EndColumn; ++i) {
            int n = this.mRangeResult.StartRow;
            while (n <= this.mRangeResult.EndRow) {
                CellAddress cellAddress = new CellAddress();
                cellAddress.Sheet = this.mRangeResult.Sheet;
                cellAddress.Column = i;
                cellAddress.Row = n++;
                DataPilotTablePositionData dataPilotTablePositionData = this.xDPTab2.getPositionData(cellAddress);
                if (dataPilotTablePositionData.PositionType != 1) {
                    this.log.println(this.formatCell(cellAddress) + ": this is not a result cell");
                    throw new ResultCellFailure();
                }
                this.mResultCells.add(cellAddress);
            }
        }
    }

    private void buildDataFields() {
        this.mDataFieldDims = new ArrayList();
        XDataPilotDescriptor xDataPilotDescriptor = (XDataPilotDescriptor)UnoRuntime.queryInterface(XDataPilotDescriptor.class, (Object)this.xDPTab2);
        XIndexAccess xIndexAccess = xDataPilotDescriptor.getDataPilotFields();
        int n = xIndexAccess.getCount();
        for (int i = 0; i < n; ++i) {
            try {
                Object object = xIndexAccess.getByIndex(i);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? _XDataPilotTable2.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, object);
                DataPilotFieldOrientation dataPilotFieldOrientation = (DataPilotFieldOrientation)xPropertySet.getPropertyValue("Orientation");
                if (dataPilotFieldOrientation != DataPilotFieldOrientation.DATA) continue;
                Integer n2 = new Integer(i);
                this.mDataFieldDims.add(n2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(this.log);
                throw new StatusException("Failed to get a field.", exception);
            }
        }
    }

    private void getOutputRanges() {
        if (this.mRangeWhole != null && this.mRangeTable != null && this.mRangeResult != null) {
            return;
        }
        try {
            this.mRangeWhole = this.xDPTab2.getOutputRangeByType(0);
            this.printRange("whole range ", this.mRangeWhole);
            this.mRangeTable = this.xDPTab2.getOutputRangeByType(1);
            this.printRange("table range ", this.mRangeTable);
            this.mRangeResult = this.xDPTab2.getOutputRangeByType(2);
            this.printRange("result range", this.mRangeResult);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(this.log);
            throw new StatusException("Failed to get output range by type.", illegalArgumentException);
        }
    }

    private boolean checkDrillDownSheetContent(XSpreadsheet xSpreadsheet, Object[][] objectArray) {
        CellAddress cellAddress = this.getLastUsedCellAddress(xSpreadsheet, 0, 0);
        if (objectArray.length <= 0 || cellAddress.Row == 0 || cellAddress.Column == 0) {
            this.log.println("empty data condition");
            return false;
        }
        if (objectArray.length != cellAddress.Row + 1 || objectArray[0].length != cellAddress.Column + 1) {
            this.log.println("data size differs");
            return false;
        }
        XCellRange xCellRange = null;
        try {
            xCellRange = xSpreadsheet.getCellRangeByPosition(0, 0, cellAddress.Column, cellAddress.Row);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        XCellRangeData xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)xCellRange);
        Object[][] objectArray2 = xCellRangeData.getDataArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            for (int j = 0; j < objectArray2[i].length; ++j) {
                Object object = objectArray2[i][j];
                Object object2 = objectArray[i][j];
                if (AnyConverter.isString((Object)object) && AnyConverter.isString((Object)object2)) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    if (string.equals(string2)) continue;
                    this.log.println("string cell values differ");
                    return false;
                }
                if (AnyConverter.isDouble((Object)object) && AnyConverter.isDouble((Object)object2)) {
                    double d = 0.0;
                    double d2 = 0.0;
                    try {
                        d = AnyConverter.toDouble((Object)object);
                        d2 = AnyConverter.toDouble((Object)object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.log.println("failed to convert cells to double");
                        return false;
                    }
                    if (d == d2) continue;
                    this.log.println("numerical cell values differ");
                    return false;
                }
                this.log.println("cell types differ");
                return false;
            }
        }
        return true;
    }

    private CellAddress getLastUsedCellAddress(XSpreadsheet xSpreadsheet, int n, int n2) {
        try {
            XCellRange xCellRange = xSpreadsheet.getCellRangeByPosition(n, n2, n, n2);
            XSheetCellRange xSheetCellRange = (XSheetCellRange)UnoRuntime.queryInterface(XSheetCellRange.class, (Object)xCellRange);
            XSheetCellCursor xSheetCellCursor = xSpreadsheet.createCursorByRange(xSheetCellRange);
            XCellCursor xCellCursor = (XCellCursor)UnoRuntime.queryInterface(XCellCursor.class, (Object)xSheetCellCursor);
            xCellCursor.gotoEnd();
            XCell xCell = xSheetCellCursor.getCellByPosition(0, 0);
            XCellAddressable xCellAddressable = (XCellAddressable)UnoRuntime.queryInterface(XCellAddressable.class, (Object)xCell);
            return xCellAddressable.getCellAddress();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private class ResultCellFailure
    extends Exception {
        private ResultCellFailure() {
        }
    }
}

