/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import [Ljava.lang.Object;;
import com.sun.star.io.XDataInputStream;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.DateTime;
import com.sun.star.util.Time;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueComparer;

public class _XRowUpdate
extends MultiMethodTest {
    public XRowUpdate oObj = null;
    private Vector rowData = null;
    private XRow row = null;

    public void before() {
        this.rowData = (Vector)this.tEnv.getObjRelation("CurrentRowData");
        if (this.rowData == null) {
            this.log.println("!!! 'CurrentRowData' relation not found !!!");
        }
        this.row = (XRow)this.tEnv.getObjRelation("XRowUpdate.XRow");
        if (this.rowData == null) {
            this.log.println("!!! 'XRowUpdate.XRow' relation not found !!!");
        }
    }

    public void _updateNull() {
        boolean bl = true;
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (this.rowData.get(i) == null) continue;
            this.log.print("  Setting NULL at column #" + (i + 1) + " ...");
            try {
                this.oObj.updateNull(i + 1);
                if (this.rowData.get(i) instanceof String) {
                    this.row.getString(i + 1);
                }
                if (this.rowData.get(i) instanceof Boolean) {
                    this.row.getBoolean(i + 1);
                }
                if (this.rowData.get(i) instanceof Byte) {
                    this.row.getByte(i + 1);
                }
                if (this.rowData.get(i) instanceof Short) {
                    this.row.getShort(i + 1);
                }
                if (this.rowData.get(i) instanceof Integer) {
                    this.row.getInt(i + 1);
                }
                if (this.rowData.get(i) instanceof Long) {
                    this.row.getLong(i + 1);
                }
                if (this.rowData.get(i) instanceof Float) {
                    this.row.getFloat(i + 1);
                }
                if (this.rowData.get(i) instanceof Double) {
                    this.row.getDouble(i + 1);
                }
                if (this.rowData.get(i) instanceof byte[]) {
                    this.row.getBytes(i + 1);
                }
                if (this.rowData.get(i) instanceof Date) {
                    this.row.getDate(i + 1);
                }
                if (this.rowData.get(i) instanceof Time) {
                    this.row.getTime(i + 1);
                }
                if (this.rowData.get(i) instanceof DateTime) {
                    this.row.getTimestamp(i + 1);
                }
                if (this.rowData.get(i) instanceof XDataInputStream) {
                    this.row.getBinaryStream(i + 1);
                }
                if (this.rowData.get(i) instanceof XTextInputStream) {
                    this.row.getCharacterStream(i + 1);
                }
                if (!this.row.wasNull()) {
                    this.log.println("FAILED");
                    this.log.println("Not NULL was returned !!!");
                    bl = false;
                    continue;
                }
                this.log.println("OK");
                continue;
            }
            catch (SQLException sQLException) {
                this.log.println("FAILED");
                sQLException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("updateNull()", bl);
    }

    public void _updateBoolean() {
        boolean bl = true;
        int n = this.findColumnOfType(Boolean.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateBoolean()", Status.skipped(true));
            return;
        }
        try {
            boolean bl2 = !this.row.getBoolean(n);
            this.oObj.updateBoolean(n, bl2);
            boolean bl3 = this.row.getBoolean(n);
            bl = bl2 == bl3;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateBoolean()", bl);
    }

    public void _updateByte() {
        boolean bl = true;
        int n = this.findColumnOfType(Byte.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateByte()", Status.skipped(true));
            return;
        }
        try {
            byte by = (byte)(this.row.getByte(n) + 1);
            this.oObj.updateByte(n, by);
            byte by2 = this.row.getByte(n);
            bl = by == by2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateByte()", bl);
    }

    public void _updateShort() {
        boolean bl = true;
        int n = this.findColumnOfType(Short.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateShort()", Status.skipped(true));
            return;
        }
        try {
            short s = (short)(this.row.getShort(n) + 1);
            this.oObj.updateShort(n, s);
            short s2 = this.row.getShort(n);
            bl = s == s2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateShort()", bl);
    }

    public void _updateInt() {
        boolean bl = true;
        int n = this.findColumnOfType(Integer.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateInt()", Status.skipped(true));
            return;
        }
        try {
            int n2 = 1 + this.row.getInt(n);
            this.oObj.updateInt(n, n2);
            int n3 = this.row.getInt(n);
            bl = n2 == n3;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateInt()", bl);
    }

    public void _updateLong() {
        boolean bl = true;
        int n = this.findColumnOfType(Long.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateLong()", Status.skipped(true));
            return;
        }
        try {
            long l = 1L + this.row.getLong(n);
            this.oObj.updateLong(n, l);
            long l2 = this.row.getLong(n);
            bl = l == l2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateLong()", bl);
    }

    public void _updateFloat() {
        boolean bl = true;
        int n = this.findColumnOfType(Float.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateFloat()", Status.skipped(true));
            return;
        }
        try {
            float f = (float)(1.1 + (double)this.row.getFloat(n));
            this.oObj.updateFloat(n, f);
            float f2 = this.row.getFloat(n);
            bl = f == f2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateFloat()", bl);
    }

    public void _updateDouble() {
        boolean bl = true;
        int n = this.findColumnOfType(Double.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateDouble()", Status.skipped(true));
            return;
        }
        try {
            double d = 1.1 + this.row.getDouble(n);
            this.oObj.updateDouble(n, d);
            double d2 = this.row.getDouble(n);
            bl = d == d2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateDouble()", bl);
    }

    public void _updateString() {
        boolean bl = true;
        int n = this.findColumnOfType(String.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateString()", Status.skipped(true));
            return;
        }
        try {
            String string = "_" + this.row.getString(n);
            this.oObj.updateString(n, string);
            String string2 = this.row.getString(n);
            bl = string.equals(string2);
            this.log.println("New value = '" + string + "', get value = '" + string2 + "'");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateString()", bl);
    }

    public void _updateBytes() {
        boolean bl = true;
        int n = this.findColumnOfType([B.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateBytes()", Status.skipped(true));
            return;
        }
        try {
            byte[] byArray = this.row.getBytes(n);
            byArray = byArray == null || byArray.length == 0 ? new byte[]{34, 111, 98} : new byte[]{(byte)(byArray[0] + 1), 111, 98};
            this.oObj.updateBytes(n, byArray);
            byte[] byArray2 = this.row.getBytes(n);
            bl = ValueComparer.equalValue(byArray, byArray2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateBytes()", bl);
    }

    public void _updateDate() {
        boolean bl = true;
        int n = this.findColumnOfType(Date.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateDate()", Status.skipped(true));
            return;
        }
        try {
            Date date = this.row.getDate(n);
            date.Year = (short)(date.Year + 1);
            this.oObj.updateDate(n, date);
            Date date2 = this.row.getDate(n);
            bl = ValueComparer.equalValue(date, date2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateDate()", bl);
    }

    public void _updateTime() {
        boolean bl = true;
        int n = this.findColumnOfType(Time.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateTime()", Status.skipped(true));
            return;
        }
        try {
            Time time = this.row.getTime(n);
            time.Seconds = (short)(time.Seconds + 1);
            this.oObj.updateTime(n, time);
            Time time2 = this.row.getTime(n);
            bl = ValueComparer.equalValue(time, time2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateTime()", bl);
    }

    public void _updateTimestamp() {
        boolean bl = true;
        int n = this.findColumnOfType(DateTime.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateTimestamp()", Status.skipped(true));
            return;
        }
        try {
            DateTime dateTime = this.row.getTimestamp(n);
            dateTime.Year = (short)(dateTime.Year + 1);
            this.oObj.updateTimestamp(n, dateTime);
            DateTime dateTime2 = this.row.getTimestamp(n);
            bl = ValueComparer.equalValue(dateTime, dateTime2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateTimestamp()", bl);
    }

    public void _updateBinaryStream() {
        boolean bl = true;
        int n = this.findColumnOfType(XDataInputStream.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateBinaryStream()", Status.skipped(true));
            return;
        }
        try {
            Object object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.DataInputStream");
            XInputStream xInputStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, object);
            this.oObj.updateBinaryStream(n, xInputStream, 0);
            XInputStream xInputStream2 = this.row.getBinaryStream(n);
            bl = UnoRuntime.areSame(xInputStream, xInputStream2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        catch (Exception exception) {
            this.log.println("Unexpected exception:");
            exception.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateBinaryStream()", bl);
    }

    public void _updateCharacterStream() {
        boolean bl = true;
        int n = this.findColumnOfType(XTextInputStream.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateCharacterStream()", Status.skipped(true));
            return;
        }
        try {
            Object object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.TextInputStream");
            XInputStream xInputStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, object);
            this.oObj.updateCharacterStream(n, xInputStream, 0);
            XInputStream xInputStream2 = this.row.getCharacterStream(n);
            bl = UnoRuntime.areSame(xInputStream, xInputStream2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        catch (Exception exception) {
            this.log.println("Unexpected exception:");
            exception.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateCharacterStream()", bl);
    }

    public void _updateObject() {
        boolean bl = true;
        int n = this.findColumnOfType(Object;.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateObject()", Status.skipped(true));
            return;
        }
        try {
            Object object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.Pipe");
            this.oObj.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        catch (Exception exception) {
            this.log.println("Unexpected exception:");
            exception.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateObject()", bl);
    }

    public void _updateNumericObject() {
        boolean bl = true;
        int n = this.findColumnOfType(Object;.class);
        if (n < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateNumericObject()", Status.skipped(true));
            return;
        }
        try {
            Object object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.Pipe");
            this.oObj.updateNumericObject(n, object, 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        catch (Exception exception) {
            this.log.println("Unexpected exception:");
            exception.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("updateNumericObject()", bl);
    }

    protected int findColumnOfType(Class clazz) {
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (!clazz.isInstance(this.rowData.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    public void after() {
        this.disposeEnvironment();
    }
}

