/*
 * Decompiled with CFR 0.152.
 */
package ifc.datatransfer.clipboard;

import com.sun.star.datatransfer.DataFlavor;
import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.clipboard.ClipboardEvent;
import com.sun.star.datatransfer.clipboard.XClipboard;
import com.sun.star.datatransfer.clipboard.XClipboardListener;
import com.sun.star.datatransfer.clipboard.XClipboardNotifier;
import com.sun.star.datatransfer.clipboard.XClipboardOwner;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XClipboardNotifier
extends MultiMethodTest {
    public XClipboardNotifier oObj;
    MyClipboardListener myListener;
    static /* synthetic */ Class class$java$lang$String;

    public void _addClipboardListener() {
        this.myListener = new MyClipboardListener();
        this.oObj.addClipboardListener(this.myListener);
        XClipboard xClipboard = (XClipboard)UnoRuntime.queryInterface(XClipboard.class, (Object)this.tEnv.getTestObject());
        xClipboard.setContents(new MyTransferable(), new MyOwner());
        this.log.println("sleeping for 1 second");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("interrupted");
            interruptedException.printStackTrace(this.log);
            throw new StatusException("Operation interrupted", interruptedException);
        }
        this.tRes.tested("addClipboardListener()", this.myListener.called);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _removeClipboardListener() {
        try {
            this.requiredMethod("addClipboardListener()");
            this.myListener.called = false;
        }
        finally {
            this.oObj.removeClipboardListener(this.myListener);
        }
        XClipboard xClipboard = (XClipboard)UnoRuntime.queryInterface(XClipboard.class, (Object)this.oObj);
        xClipboard.setContents(new MyTransferable(), new MyOwner());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("interrupted");
            interruptedException.printStackTrace(this.log);
            throw new StatusException("Operation interrupted", interruptedException);
        }
        this.tRes.tested("removeClipboardListener()", !this.myListener.called);
    }

    class MyClipboardListener
    implements XClipboardListener {
        boolean called = false;

        MyClipboardListener() {
        }

        public void changedContents(ClipboardEvent clipboardEvent) {
            this.called = true;
        }

        public void disposing(EventObject eventObject) {
            _XClipboardNotifier.this.log.println("");
        }
    }

    class MyTransferable
    implements XTransferable {
        DataFlavor[] supportedFlavors = new DataFlavor[]{new DataFlavor("text/plain", "Plain text", new Type(class$java$lang$String == null ? (class$java$lang$String = _XClipboardNotifier.class$("java.lang.String")) : class$java$lang$String))};

        public Object getTransferData(DataFlavor dataFlavor) {
            return "";
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.supportedFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.supportedFlavors[0].MimeType.equals(dataFlavor.MimeType);
        }
    }

    class MyOwner
    implements XClipboardOwner {
        XClipboard board;
        XTransferable contents;

        MyOwner() {
        }

        public void lostOwnership(XClipboard xClipboard, XTransferable xTransferable) {
            this.board = xClipboard;
            this.contents = xTransferable;
        }
    }
}

