/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt.tree;

import com.sun.star.awt.tree.XTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTreeNode
extends MultiMethodTest {
    public XTreeNode oObj = null;
    private int mCount = 0;
    String msDisplayValue = null;
    String msExpandedGraphicURL = null;
    String msCollapsedGraphicURL = null;
    String msNodeGraphicURL = null;

    public void before() {
        this.msDisplayValue = (String)this.tEnv.getObjRelation("XTreeNode_DisplayValue");
        if (this.msDisplayValue == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_DisplayVlaue'"));
        }
        this.msExpandedGraphicURL = (String)this.tEnv.getObjRelation("XTreeNode_ExpandedGraphicURL");
        if (this.msExpandedGraphicURL == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_ExpandedGraphicURL'"));
        }
        this.msCollapsedGraphicURL = (String)this.tEnv.getObjRelation("XTreeNode_CollapsedGraphicURL");
        if (this.msCollapsedGraphicURL == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_CollapsedGraphicURL'"));
        }
        this.msNodeGraphicURL = (String)this.tEnv.getObjRelation("XTreeNode_NodeGraphicURL");
        if (this.msNodeGraphicURL == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_NodeGraphicURL'"));
        }
    }

    public void _getChildAt() {
        this.requiredMethod("getChildCount()");
        boolean bl = true;
        for (int i = 0; i < this.mCount; ++i) {
            XTreeNode xTreeNode = null;
            try {
                xTreeNode = this.oObj.getChildAt(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("ERROR: getChildAt(" + i + "): " + indexOutOfBoundsException.toString());
            }
            if (xTreeNode != null) continue;
            this.log.println("ERROR: getChildAt(" + i + ") returns null => FAILED");
            bl = false;
        }
        this.tRes.tested("getChildAt()", bl);
    }

    public void _getChildCount() {
        boolean bl = true;
        this.mCount = this.oObj.getChildCount();
        this.log.println("got count '" + this.mCount + "' of children");
        if (this.mCount < 1) {
            this.log.println("ERROR: got a count < 1. The test object must be support morw then zero children => FAILED");
            bl = false;
        }
        this.tRes.tested("getChildCount()", bl);
    }

    public void _getParent() {
        this.requiredMethod("getChildAt()");
        boolean bl = true;
        XTreeNode xTreeNode = null;
        try {
            this.log.println("try to getChildAt(0)");
            xTreeNode = this.oObj.getChildAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("ERROR: getChildAt(0): " + indexOutOfBoundsException.toString());
        }
        this.log.println("try to get parrent of children");
        XTreeNode xTreeNode2 = xTreeNode.getParent();
        bl = this.oObj.equals(xTreeNode2);
        this.log.println("original object and parrent should be the same: " + bl);
        this.tRes.tested("getParent()", bl);
    }

    public void _getIndex() {
        this.requiredMethod("getChildAt()");
        boolean bl = true;
        XTreeNode xTreeNode = null;
        try {
            this.log.println("try to getChildAt(0)");
            xTreeNode = this.oObj.getChildAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("ERROR: getChildAt(0): " + indexOutOfBoundsException.toString());
        }
        this.log.println("try to get index from child...");
        int n = this.oObj.getIndex(xTreeNode);
        if (n != 0) {
            this.log.println("ERROR: getIndex() does not return '0' => FAILED");
            bl = false;
        }
        this.tRes.tested("getIndex()", bl);
    }

    public void _hasChildrenOnDemand() {
        boolean bl = true;
        bl = this.oObj.hasChildrenOnDemand();
        this.tRes.tested("hasChildrenOnDemand()", bl);
    }

    public void _getDisplayValue() {
        boolean bl = true;
        String string = null;
        Object object = this.oObj.getDisplayValue();
        try {
            string = AnyConverter.toString((Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("ERROR: could not convert the returned object of 'getDisplyValue()' to String with AnyConverter: " + illegalArgumentException.toString());
        }
        if (!this.msDisplayValue.equals(string)) {
            this.log.println("ERROR: getNodeGraphicURL() does not return expected value:\n\tExpected: " + this.msDisplayValue + "\n" + "\tGot: " + string);
            bl = false;
        }
        this.tRes.tested("getDisplayValue()", bl);
    }

    public void _getNodeGraphicURL() {
        boolean bl = true;
        String string = this.oObj.getNodeGraphicURL();
        if (!this.msNodeGraphicURL.equals(string)) {
            this.log.println("ERROR: getNodeGraphicURL() does not return expected value:\n\tExpected: " + this.msNodeGraphicURL + "\n" + "\tGot: " + string);
            bl = false;
        }
        this.tRes.tested("getNodeGraphicURL()", bl);
    }

    public void _getExpandedGraphicURL() {
        boolean bl = true;
        String string = this.oObj.getExpandedGraphicURL();
        if (!this.msExpandedGraphicURL.equals(string)) {
            this.log.println("ERROR: getExpandedGraphicURL() does not return expected value:\n\tExpected: " + this.msExpandedGraphicURL + "\n" + "\tGot: " + string);
            bl = false;
        }
        this.tRes.tested("getExpandedGraphicURL()", bl);
    }

    public void _getCollapsedGraphicURL() {
        boolean bl = true;
        String string = this.oObj.getCollapsedGraphicURL();
        if (!this.msCollapsedGraphicURL.equals(string)) {
            this.log.println("ERROR: getExpandedGraphicURL() does not return expected value:\n\tExpected: " + this.msCollapsedGraphicURL + "\n" + "\tGot: " + string);
            bl = false;
        }
        this.tRes.tested("getCollapsedGraphicURL()", bl);
    }
}

