/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt.tree;

import com.sun.star.awt.tree.XMutableTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XMutableTreeNode
extends MultiMethodTest {
    public XMutableTreeNode oObj = null;
    private int mCount = 0;
    private XMutableTreeNodeCreator nodeCreator = null;

    public void before() {
        this.nodeCreator = (XMutableTreeNodeCreator)this.tEnv.getObjRelation("XMutableTreeNodeCreator");
        if (this.nodeCreator == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XMutableTreeNodeCreator'"));
        }
    }

    public void _appendChild() {
        boolean bl = true;
        this.log.println("try to append a valid node...");
        XMutableTreeNode xMutableTreeNode = this.nodeCreator.createNode("myNodeToAppend");
        try {
            this.oObj.appendChild(xMutableTreeNode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("ERROR: could not appedn a valid node: " + illegalArgumentException.toString());
            bl = false;
        }
        this.log.println("try to append the node a second time...");
        try {
            this.oObj.appendChild(xMutableTreeNode);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected IllegalArgumentException was thrown => OK");
        }
        this.log.println("try to append the object itself...");
        try {
            this.oObj.appendChild(this.oObj);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected IllegalArgumentException was thrown => OK");
        }
        this.tRes.tested("appendChild()", bl);
    }

    public void _insertChildByIndex() {
        boolean bl = true;
        XMutableTreeNode xMutableTreeNode = this.nodeCreator.createNode("myNodeToInsert");
        try {
            this.log.println("try to insert a valid node...");
            this.oObj.insertChildByIndex(0, xMutableTreeNode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("ERROR: could not insert a valid node: " + illegalArgumentException.toString());
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("ERROR: could not insert a valid node on index '0': " + indexOutOfBoundsException.toString());
            bl = false;
        }
        try {
            this.log.println("try to insert a valid node a second time...");
            this.oObj.insertChildByIndex(0, xMutableTreeNode);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected IllegalArgumentException wa thrown => OK");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("ERROR: wrong IndexOutOfBoundsException was thrown. Expected is IllegalArgumentException => FAILED");
            bl = false;
        }
        XMutableTreeNode xMutableTreeNode2 = this.nodeCreator.createNode("myNodeToInsert2");
        try {
            this.log.println("try to insert a valid node on invalid index '-3'...");
            this.oObj.insertChildByIndex(-3, xMutableTreeNode2);
            this.log.println("ERROR: expected IndexOutOfBoundsException was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("ERROR: wrong IllegalArgumentException was thrown. Expeced is IndexOutOfBoundsException => FAILED");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Expected IndexOutOfBoundsException was thrown => OK");
        }
        try {
            this.log.println("try to insert the object itself...");
            this.oObj.insertChildByIndex(0, this.oObj);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected IllegalArgumentException was thrown => OK");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("unexpected IndexOutOfBoundsException was thrown, expected was IllegalArgumentException => FAILED");
            bl = false;
        }
        this.tRes.tested("insertChildByIndex()", bl);
    }

    public void _removeChildByIndex() {
        this.requiredMethod("insertChildByIndex()");
        boolean bl = true;
        try {
            this.log.println("try to remove node at index '0'...");
            this.oObj.removeChildByIndex(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("ERROR: IndexOutOfBoundsException was thrown => FAILED");
            bl = false;
        }
        try {
            this.log.println("try to remove node at invalid index '-3'");
            this.oObj.removeChildByIndex(-3);
            this.log.println("ERROR: expeced IndexOutOfBoundsException was not thrown => FAILED");
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected IndexOutOfBoundsException was thrown => OK");
        }
        this.tRes.tested("removeChildByIndex()", bl);
    }

    public void _setHasChildrenOnDemand() {
        boolean bl = true;
        this.log.println("setHasChildrenOnDemand(true)");
        this.oObj.setHasChildrenOnDemand(true);
        this.log.println("setHasChildrenOnDemand(false)");
        this.oObj.setHasChildrenOnDemand(false);
        this.tRes.tested("setHasChildrenOnDemand()", bl);
    }

    public void _setDisplayValue() {
        boolean bl = true;
        this.log.println("setDisplayValue(\"MyTestValue\")");
        this.oObj.setDisplayValue("MyTestValue");
        this.log.println("setDisplayValue(null)");
        this.oObj.setDisplayValue(null);
        this.log.println("oObj.setDisplayValue(oObj)");
        this.oObj.setDisplayValue(this.oObj);
        this.tRes.tested("setDisplayValue()", bl);
    }

    public void _setNodeGraphicURL() {
        boolean bl = true;
        this.log.println("setNodeGraphicURL(\"MyTestURL\")");
        this.oObj.setNodeGraphicURL("MyTestURL");
        this.log.println("setNodeGraphicURL(null)");
        this.oObj.setNodeGraphicURL(null);
        this.tRes.tested("setNodeGraphicURL()", bl);
    }

    public void _setExpandedGraphicURL() {
        boolean bl = true;
        this.log.println("setExpandedGraphicURL(\"myExpandedURL\")");
        this.oObj.setExpandedGraphicURL("myExpandedURL");
        this.log.println("setExpandedGraphicURL(null)");
        this.oObj.setExpandedGraphicURL(null);
        this.tRes.tested("setExpandedGraphicURL()", bl);
    }

    public void _setCollapsedGraphicURL() {
        boolean bl = true;
        this.log.println("setCollapsedGraphicURL(\"myCollapsedURL\")");
        this.oObj.setCollapsedGraphicURL("myCollapsedURL");
        this.log.println("setCollapsedGraphicURL(null)");
        this.oObj.setCollapsedGraphicURL(null);
        this.tRes.tested("setCollapsedGraphicURL()", bl);
    }

    public void _DataValue() {
        boolean bl = true;
        this.log.println("setDataValue(\"myDataValue\")");
        this.oObj.setDataValue("myDataValue");
        String string = (String)this.oObj.getDataValue();
        if (!string.equals("myDataValue")) {
            this.log.println("ERROR: getDataVlaue does not return the value which is inserted before:\n\texpected: myDataValue\n\tgot: " + string);
            bl = false;
        }
        this.log.println("setDataValue(null)");
        this.oObj.setDataValue(null);
        Object object = this.oObj.getDataValue();
        if (object != null) {
            this.log.println("ERROR: getDataVlaue does not return the value which is inserted before:\n\texpected: null\n\tgot: " + object.toString());
            bl = false;
        }
        this.log.println("oObj.setDisplayValue(oObj)");
        this.oObj.setDisplayValue(this.oObj);
        object = this.oObj.getDataValue();
        if (object != null) {
            this.log.println("ERROR: getDataVlaue does not return the value which is inserted before:\n\texpected: " + this.oObj.toString() + "\n" + "\tgot: " + object.toString());
            bl = false;
        }
        this.tRes.tested("DataValue()", bl);
    }

    public static interface XMutableTreeNodeCreator {
        public XMutableTreeNode createNode(String var1);
    }
}

